/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.etl;

import com.ptteng.judao.common.model.GameOrders;
import com.ptteng.judao.common.service.GameOrdersService;
import com.ptteng.judao.etl.BillTimeOut;
import com.ptteng.judao.etl.unit.ConfigUtil;
import com.ptteng.judao.etl.unit.DynamicUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectTimeOut {
    private static final Log log = LogFactory.getLog(BillTimeOut.class);
    private GameOrdersService gameOrdersService;
    private static final String userTime = ConfigUtil.getProperty("user_time");
    private static final int TASK_LEN = 100;
    private static boolean flag = false;

    public GameOrdersService getGameOrdersService() {
        return this.gameOrdersService;
    }

    public void setGameOrdersService(GameOrdersService gameOrdersService) {
        this.gameOrdersService = gameOrdersService;
    }

    public void process() {
        try {
            log.info((Object)"\u6253\u624b\u5f85\u652f\u4ed8\u8d85\u65f6\u7684\u8ba2\u5355");
            Long endAt = System.currentTimeMillis() - Long.valueOf(userTime);
            Map<String, Object> map = DynamicUtil.getGameOrderByBeater(GameOrders.STATUS_RECEIVED_UPPAY, endAt, false);
            do {
                List ids;
                if (CollectionUtils.isEmpty((Collection)(ids = this.gameOrdersService.getIdsByDynamicCondition(GameOrders.class, map, Integer.valueOf(0), Integer.valueOf(100))))) {
                    log.info((Object)"not get any more than 15 minute rent orders ");
                    flag = false;
                    continue;
                }
                if (ids.size() < 100) {
                    log.info((Object)"not have next page");
                    flag = false;
                } else {
                    log.info((Object)"have next page");
                    flag = true;
                }
                List gameOrdersList = this.gameOrdersService.getObjectsByIds(ids);
                for (GameOrders gameOrders : gameOrdersList) {
                    gameOrders.setStatus(GameOrders.STATUS_UNRECEIVED);
                    gameOrders.setReceiverId(Long.valueOf(0L));
                    gameOrders.setReceiptTime(Long.valueOf(0L));
                }
                this.gameOrdersService.updateList(gameOrdersList);
            } while (flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"update game order list  fail===");
        }
    }
}

