/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.judao.common.model.Studio;
import com.ptteng.judao.common.service.StudioService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StudioServiceImpl
extends BaseDaoServiceImpl
implements StudioService {
    private static final Log log = LogFactory.getLog(StudioServiceImpl.class);

    public Long insert(Studio studio) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + studio));
        if (studio == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        studio.setCreateAt(Long.valueOf(currentTimeMillis));
        studio.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)studio);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + studio));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Studio> insertList(List<Studio> studioList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (studioList == null ? "null" : Integer.valueOf(studioList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(studioList)) {
            return new ArrayList<Studio>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Studio studio : studioList) {
            studio.setCreateAt(Long.valueOf(currentTimeMillis));
            studio.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(studioList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + studioList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Studio.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Studio studio) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (studio == null ? "null" : studio.getId())));
        boolean result = false;
        if (studio == null) {
            return true;
        }
        studio.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)studio);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + studio));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + studio));
        }
        return result;
    }

    public boolean updateList(List<Studio> studioList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (studioList == null ? "null" : Integer.valueOf(studioList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(studioList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Studio studio : studioList) {
            studio.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(studioList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + studioList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + studioList.size()));
        return result;
    }

    public Studio getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Studio studio = null;
        if (id == null) {
            return studio;
        }
        try {
            studio = (Studio)this.dao.get(Studio.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return studio;
    }

    public List<Studio> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List studio = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Studio>();
        }
        try {
            studio = this.dao.getList(Studio.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (studio == null ? "null" : Integer.valueOf(studio.size()))));
        return studio;
    }

    public List<Long> getStudioIdsByStudioNick(String studioNick, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by studioNick,start,limit  : " + studioNick + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStudioIdsByStudioNick", new Object[]{studioNick}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by studioNick,start,limit)  : " + studioNick + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getStudioIdByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid  : " + uid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getStudioIdByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getStudioIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStudioIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStudioIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStudioIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStudioIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

