/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.sms.service.VoiceSendService;
import com.ptteng.judao.common.model.Sms;
import com.ptteng.judao.common.service.SmsService;
import com.ptteng.judao.common.service.impl.AliSmsSendServiceImpl;
import com.ptteng.judao.common.util.cft.DateTimeUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmsServiceImpl
extends BaseDaoServiceImpl
implements SmsService {
    private static final Log log = LogFactory.getLog(SmsServiceImpl.class);
    private Map<String, String> type_template = new HashMap<String, String>();
    private AliSmsSendServiceImpl aliSmsSendService;
    private VoiceSendService voiceSendService;
    private String registered = "\u6ce8\u518c\u8d26\u53f7";
    private String password = "\u627e\u56de\u5bc6\u7801";
    private String login = "\u767b\u5f55";
    private String changeMessage = "\u4fe1\u606f\u53d8\u66f4";

    public AliSmsSendServiceImpl getAliSmsSendService() {
        return this.aliSmsSendService;
    }

    public void setSmsSendService(AliSmsSendServiceImpl aliSmsSendService) {
        this.aliSmsSendService = aliSmsSendService;
    }

    public Map<String, String> getType_template() {
        return this.type_template;
    }

    public void setType_template(Map<String, String> type_template) {
        this.type_template = type_template;
    }

    public VoiceSendService getVoiceSendService() {
        return this.voiceSendService;
    }

    public void setVoiceSendService(VoiceSendService voiceSendService) {
        this.voiceSendService = voiceSendService;
    }

    public Long insert(Sms sms) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + sms));
        if (sms == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        sms.setCreateAt(Long.valueOf(currentTimeMillis));
        sms.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)sms);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + sms));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Sms> insertList(List<Sms> smsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (smsList == null ? "null" : Integer.valueOf(smsList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(smsList)) {
            return new ArrayList<Sms>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Sms sms : smsList) {
            sms.setCreateAt(Long.valueOf(currentTimeMillis));
            sms.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(smsList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + smsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Sms.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Sms sms) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (sms == null ? "null" : sms.getId())));
        boolean result = false;
        if (sms == null) {
            return true;
        }
        sms.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)sms);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + sms));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + sms));
        }
        return result;
    }

    public boolean updateList(List<Sms> smsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (smsList == null ? "null" : Integer.valueOf(smsList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(smsList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Sms sms : smsList) {
            sms.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(smsList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + smsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + smsList.size()));
        return result;
    }

    public Sms getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Sms sms = null;
        if (id == null) {
            return sms;
        }
        try {
            sms = (Sms)this.dao.get(Sms.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return sms;
    }

    public List<Sms> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List sms = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Sms>();
        }
        try {
            sms = this.dao.getList(Sms.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (sms == null ? "null" : Integer.valueOf(sms.size()))));
        return sms;
    }

    public Long getSmsIdByMobileAndType(String mobile, String type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by mobile,type  : " + mobile + " , " + type));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getSmsIdByMobileAndType", new Object[]{mobile, type});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by mobile,type  : " + mobile + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getSmsIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSmsIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSmsIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSmsIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSmsIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public String sendMsg(String phone, String type) throws ServiceException, ServiceDaoException {
        if (!this.type_template.containsKey(type)) {
            log.info((Object)(type + " is not limit "));
            return "invalideType";
        }
        String code = "";
        String codeMessage = "";
        int count = 0;
        Sms sms = new Sms();
        Long smsId = this.getSmsIdByMobileAndType(phone, type);
        if (smsId != null) {
            sms = this.getObjectById(smsId);
            Long currentTime = System.currentTimeMillis();
            log.info((Object)("\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4" + currentTime));
            Long sendMessageTime = sms.getSendAt();
            log.info((Object)("\u4e0a\u4e00\u6761\u77ed\u4fe1\u53d1\u9001\u65f6\u95f4" + sendMessageTime));
            if (!DateTimeUtil.isSameDay(currentTime, sendMessageTime)) {
                sms.setCount(count);
            }
            if (sms.getCount() < 5) {
                Long delay = System.currentTimeMillis() - sms.getTypeSendAt();
                if (delay <= 900000L) {
                    log.info((Object)"15\u5206\u949f\u5185\u53d1\u9001\u76f8\u540c\u9a8c\u8bc1\u7801");
                    code = sms.getMessage();
                    String returnString = "";
                    returnString = this.getReturnStringByType(phone, type, code, returnString);
                    if (returnString.equals("sendOk")) {
                        log.info((Object)("\u77ed\u4fe1\u53d1\u9001\u8fd4\u56de\u503c\uff1a" + returnString));
                        sms.setSendAt(Long.valueOf(System.currentTimeMillis()));
                        count = sms.getCount();
                        log.info((Object)("this db message count is ============" + count));
                        sms.setCount(++count);
                        this.update(sms);
                        log.info((Object)"\u4fe1\u606f\u53d1\u9001\u6210\u529f");
                        return returnString;
                    }
                    return "sendError";
                }
                Random rand = new Random();
                for (int i = 0; i < 6; ++i) {
                    code = code + rand.nextInt(10);
                }
                code = code.trim();
                String returnString = "";
                if ((returnString = this.getReturnStringByType(phone, type, code, returnString)).equals("sendOk")) {
                    log.info((Object)("\u77ed\u4fe1\u53d1\u9001\u8fd4\u56de\u503c\uff1a" + returnString));
                    sms.setSendAt(Long.valueOf(System.currentTimeMillis()));
                    sms.setTypeSendAt(Long.valueOf(System.currentTimeMillis()));
                    count = sms.getCount();
                    sms.setCount(++count);
                    sms.setMessage(code);
                    this.update(sms);
                    return returnString;
                }
                return "sendError";
            }
            log.info((Object)"count > 5 ");
            return "smsMoreThan5";
        }
        log.info((Object)"this  user is first to send code =====");
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            code = code + rand.nextInt(10);
        }
        code = code.trim();
        log.info((Object)("create random code is ============" + code));
        sms.setCount(0);
        String returnString = "";
        try {
            returnString = this.getReturnStringByType(phone, type, code, returnString);
            log.info((Object)("send message result is ============" + returnString));
            if (returnString.equals("sendOk")) {
                log.info((Object)("\u77ed\u4fe1\u53d1\u9001\u8fd4\u56de\u503c\uff1a" + returnString));
                ++count;
                sms.setMobile(phone);
                sms.setType(type);
                sms.setMessage(code);
                sms.setSendAt(Long.valueOf(System.currentTimeMillis()));
                sms.setTypeSendAt(Long.valueOf(System.currentTimeMillis()));
                sms.setCount(count);
                Long ms = this.insert(sms);
                log.info((Object)("\u53d1\u9001\u6210\u529f\uff01 \u4fe1\u606f\u4fdd\u5b58\u7ed3\u679c\uff1a" + ms));
                this.update(sms);
                return returnString;
            }
            return "sendError";
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
            return "";
        }
    }

    private String getReturnStringByType(String phone, String type, String code, String returnString) {
        switch (type) {
            case "register": {
                returnString = this.sendSms(phone, type, new String[]{code});
                break;
            }
            case "password": {
                returnString = this.sendSms(phone, type, new String[]{code});
                break;
            }
            case "login": {
                returnString = this.sendSms(phone, type, new String[]{code});
                break;
            }
            case "changeWithdraw": {
                returnString = this.sendSms(phone, type, new String[]{code});
                break;
            }
            case "changePayPwd": {
                returnString = this.sendSms(phone, type, new String[]{code});
                break;
            }
            case "orderInform": {
                returnString = this.sendSms(phone, type, null);
            }
        }
        return returnString;
    }

    private String sendSms(String phone, String type, String[] params) {
        log.info((Object)("this type is : =====" + type));
        String template = this.type_template.get(type);
        log.info((Object)(phone + " and type is " + type + " params " + params + " template " + template));
        String returnString = null;
        try {
            returnString = this.aliSmsSendService.sendSMSByTemplate(phone, template, params);
            log.info((Object)returnString);
            return returnString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return returnString;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String sendVoice(String phone, String type) throws ServiceException, ServiceDaoException {
        if (!this.type_template.containsKey(type)) {
            log.info((Object)(type + " is not limit "));
            return "invalideType";
        }
        String code = "";
        int count = 0;
        Sms sms = new Sms();
        Long smsId = this.getSmsIdByMobileAndType(phone, type);
        if (smsId != null) {
            String stime;
            sms = this.getObjectById(smsId);
            SimpleDateFormat formatter = new SimpleDateFormat("d");
            String ftime = formatter.format(System.currentTimeMillis());
            if (!ftime.equals(stime = formatter.format(sms.getSendAt()))) {
                sms.setCount(0);
            }
            int intNum = sms.getCount() + 1;
            String num = "" + intNum;
            if (sms.getCount() < 5) {
                Long delay = System.currentTimeMillis() - sms.getTypeSendAt();
                if (delay <= 1800000L) {
                    log.info((Object)"30\u5206\u949f\u5185\u53d1\u9001\u76f8\u540c\u9a8c\u8bc1\u7801");
                    code = sms.getMessage();
                    String sendResult = this.voiceSendService.sendVoice(phone, code);
                    log.info((Object)("sendResult\uff1a" + sendResult));
                    if (sendResult.startsWith("Error")) {
                        return "sendError";
                    }
                    sms.setSendAt(Long.valueOf(System.currentTimeMillis()));
                    count = sms.getCount();
                    sms.setCount(++count);
                    log.info((Object)"\u8bed\u97f3\u53d1\u9001\u6210\u529f");
                } else {
                    Random rand = new Random();
                    for (int i = 0; i < 6; ++i) {
                        code = code + rand.nextInt(10);
                    }
                    code = code.trim();
                    String sendResult = this.voiceSendService.sendVoice(phone, code);
                    log.info((Object)("sendResult\uff1a" + sendResult));
                    if (sendResult.startsWith("Error")) {
                        return "sendError";
                    }
                    sms.setSendAt(Long.valueOf(System.currentTimeMillis()));
                    sms.setTypeSendAt(Long.valueOf(System.currentTimeMillis()));
                    count = sms.getCount();
                    sms.setCount(++count);
                    sms.setMessage(code);
                    log.info((Object)"\u8d85\u8fc730\u5206\u949f\u53d1\u9001\u65b0\u9a8c\u8bc1\u7801");
                }
                this.update(sms);
                return "";
            }
            log.info((Object)"count > 5 ");
            return "smsMoreThan5";
        }
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            code = code + rand.nextInt(10);
        }
        code = code.trim();
        sms.setCount(0);
        int intNum = sms.getCount() + 1;
        String num = "" + intNum;
        try {
            String sendResult = this.voiceSendService.sendVoice(phone, code);
            log.info((Object)("sendResult\uff1a" + sendResult));
            if (sendResult.startsWith("Error")) {
                return "sendError";
            }
            ++count;
            sms.setMobile(phone);
            sms.setType(type);
            sms.setMessage(code);
            sms.setSendAt(Long.valueOf(System.currentTimeMillis()));
            sms.setTypeSendAt(Long.valueOf(System.currentTimeMillis()));
            sms.setCount(count);
            Long ms = this.insert(sms);
            log.info((Object)("\u53d1\u9001\u6210\u529f\uff01 \u4fdd\u5b58\u7ed3\u679c\uff1a" + ms));
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}

