/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.judao.common.model.Game;
import com.ptteng.judao.common.service.GameService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GameServiceImpl
extends BaseDaoServiceImpl
implements GameService {
    private static final Log log = LogFactory.getLog(GameServiceImpl.class);

    public Long insert(Game game) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + game));
        if (game == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        game.setCreateAt(Long.valueOf(currentTimeMillis));
        game.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)game);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + game));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Game> insertList(List<Game> gameList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (gameList == null ? "null" : Integer.valueOf(gameList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(gameList)) {
            return new ArrayList<Game>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Game game : gameList) {
            game.setCreateAt(Long.valueOf(currentTimeMillis));
            game.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(gameList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + gameList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Game.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Game game) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (game == null ? "null" : game.getId())));
        boolean result = false;
        if (game == null) {
            return true;
        }
        game.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)game);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + game));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + game));
        }
        return result;
    }

    public boolean updateList(List<Game> gameList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (gameList == null ? "null" : Integer.valueOf(gameList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(gameList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Game game : gameList) {
            game.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(gameList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + gameList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + gameList.size()));
        return result;
    }

    public Game getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Game game = null;
        if (id == null) {
            return game;
        }
        try {
            game = (Game)this.dao.get(Game.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return game;
    }

    public List<Game> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List game = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Game>();
        }
        try {
            game = this.dao.getList(Game.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (game == null ? "null" : Integer.valueOf(game.size()))));
        return game;
    }

    public List<Long> getGameIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGameIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGameIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getGameIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getGameIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long getGameIdByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name  : " + name));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getGameIdByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }
}

