/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.judao.common.model.GameOrders;
import com.ptteng.judao.common.service.GameOrdersService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GameOrdersServiceImpl
extends BaseDaoServiceImpl
implements GameOrdersService {
    private static final Log log = LogFactory.getLog(GameOrdersServiceImpl.class);

    public Long insert(GameOrders gameOrders) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + gameOrders));
        if (gameOrders == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        gameOrders.setCreateAt(Long.valueOf(currentTimeMillis));
        gameOrders.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)gameOrders);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + gameOrders));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<GameOrders> insertList(List<GameOrders> gameOrdersList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (gameOrdersList == null ? "null" : Integer.valueOf(gameOrdersList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(gameOrdersList)) {
            return new ArrayList<GameOrders>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GameOrders gameOrders : gameOrdersList) {
            gameOrders.setCreateAt(Long.valueOf(currentTimeMillis));
            gameOrders.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(gameOrdersList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + gameOrdersList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(GameOrders.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(GameOrders gameOrders) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (gameOrders == null ? "null" : gameOrders.getGameOrderId())));
        boolean result = false;
        if (gameOrders == null) {
            return true;
        }
        gameOrders.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)gameOrders);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + gameOrders));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + gameOrders));
        }
        return result;
    }

    public boolean updateList(List<GameOrders> gameOrdersList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (gameOrdersList == null ? "null" : Integer.valueOf(gameOrdersList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(gameOrdersList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GameOrders gameOrders : gameOrdersList) {
            gameOrders.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(gameOrdersList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + gameOrdersList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + gameOrdersList.size()));
        return result;
    }

    public GameOrders getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        GameOrders gameOrders = null;
        if (id == null) {
            return gameOrders;
        }
        try {
            gameOrders = (GameOrders)this.dao.get(GameOrders.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return gameOrders;
    }

    public List<GameOrders> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List gameOrders = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<GameOrders>();
        }
        try {
            gameOrders = this.dao.getList(GameOrders.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (gameOrders == null ? "null" : Integer.valueOf(gameOrders.size()))));
        return gameOrders;
    }

    public List<Long> getGameOrderIdsByBillerIdAndStatus(Long billerId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get gameOrderIds by billerId,status,start,limit  : " + billerId + " , " + status + " , " + start + " , " + limit));
        }
        List gameOrderIdList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            gameOrderIdList = this.dao.getIdList("getGameOrderIdsByBillerIdAndStatus", new Object[]{billerId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get gameOrderIds  wrong by billerId,status,start,limit)  : " + billerId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get gameOrderIds success : " + (gameOrderIdList == null ? "null" : Integer.valueOf(gameOrderIdList.size()))));
        }
        return gameOrderIdList;
    }

    public Long getGameOrdersGameOrderIdByGameOrderNo(String gameOrderNo) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get gameOrderId by gameOrderNo  : " + gameOrderNo));
        }
        Long gameOrderId = null;
        try {
            gameOrderId = (Long)this.dao.getMapping("getGameOrdersGameOrderIdByGameOrderNo", new Object[]{gameOrderNo});
        }
        catch (DaoException e) {
            log.error((Object)(" get gameOrderId wrong by gameOrderNo  : " + gameOrderNo));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get gameOrderId success : " + gameOrderId));
        }
        return gameOrderId;
    }

    public List<Long> getGameOrderIdsByReceiverIdAndStatus(Long receiverId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get gameOrderIds by receiverId,status,start,limit  : " + receiverId + " , " + status + " , " + start + " , " + limit));
        }
        List gameOrderIdList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            gameOrderIdList = this.dao.getIdList("getGameOrderIdsByReceiverIdAndStatus", new Object[]{receiverId, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get gameOrderIds  wrong by receiverId,status,start,limit)  : " + receiverId + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get gameOrderIds success : " + (gameOrderIdList == null ? "null" : Integer.valueOf(gameOrderIdList.size()))));
        }
        return gameOrderIdList;
    }

    public List<Long> getGameOrderIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get gameOrderIds by status,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List gameOrderIdList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            gameOrderIdList = this.dao.getIdList("getGameOrderIdsByStatus", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get gameOrderIds  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get gameOrderIds success : " + (gameOrderIdList == null ? "null" : Integer.valueOf(gameOrderIdList.size()))));
        }
        return gameOrderIdList;
    }

    public Integer countGameOrderIdsByBillerIdAndStatus(Long billerId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count gameOrderIds by billerId,status  : " + billerId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGameOrderIdsByBillerIdAndStatus", new Object[]{billerId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count gameOrderIds  wrong by billerId,status)  : " + billerId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countGameOrderIdsByReceiverIdAndStatus(Long receiverId, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count gameOrderIds by receiverId,status  : " + receiverId + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGameOrderIdsByReceiverIdAndStatus", new Object[]{receiverId, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count gameOrderIds  wrong by receiverId,status)  : " + receiverId + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countGameOrderIdsByStatus(Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count gameOrderIds by status  : " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGameOrderIdsByStatus", new Object[]{status});
        }
        catch (DaoException e) {
            log.error((Object)(" count gameOrderIds  wrong by status)  : " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getGameOrdersIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGameOrdersIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGameOrdersIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getGameOrdersIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getGameOrdersIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getGameOrderIdsByFid(Long fid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get gameOrderIds by fid,start,limit  : " + fid + " , " + start + " , " + limit));
        }
        List gameOrderIdList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            gameOrderIdList = this.dao.getIdList("getGameOrderIdsByFid", new Object[]{fid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get gameOrderIds  wrong by fid,start,limit)  : " + fid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get gameOrderIds success : " + (gameOrderIdList == null ? "null" : Integer.valueOf(gameOrderIdList.size()))));
        }
        return gameOrderIdList;
    }
}

