/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.judao.common.model.GameAttributes;
import com.ptteng.judao.common.service.GameAttributesService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GameAttributesServiceImpl
extends BaseDaoServiceImpl
implements GameAttributesService {
    private static final Log log = LogFactory.getLog(GameAttributesServiceImpl.class);

    public Long insert(GameAttributes gameAttributes) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + gameAttributes));
        if (gameAttributes == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        gameAttributes.setCreateAt(Long.valueOf(currentTimeMillis));
        gameAttributes.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)gameAttributes);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + gameAttributes));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<GameAttributes> insertList(List<GameAttributes> gameAttributesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (gameAttributesList == null ? "null" : Integer.valueOf(gameAttributesList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(gameAttributesList)) {
            return new ArrayList<GameAttributes>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GameAttributes gameAttributes : gameAttributesList) {
            gameAttributes.setCreateAt(Long.valueOf(currentTimeMillis));
            gameAttributes.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(gameAttributesList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + gameAttributesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(GameAttributes.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(GameAttributes gameAttributes) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (gameAttributes == null ? "null" : gameAttributes.getId())));
        boolean result = false;
        if (gameAttributes == null) {
            return true;
        }
        gameAttributes.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)gameAttributes);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + gameAttributes));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + gameAttributes));
        }
        return result;
    }

    public boolean updateList(List<GameAttributes> gameAttributesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (gameAttributesList == null ? "null" : Integer.valueOf(gameAttributesList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(gameAttributesList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GameAttributes gameAttributes : gameAttributesList) {
            gameAttributes.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(gameAttributesList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + gameAttributesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + gameAttributesList.size()));
        return result;
    }

    public GameAttributes getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        GameAttributes gameAttributes = null;
        if (id == null) {
            return gameAttributes;
        }
        try {
            gameAttributes = (GameAttributes)this.dao.get(GameAttributes.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return gameAttributes;
    }

    public List<GameAttributes> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List gameAttributes = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<GameAttributes>();
        }
        try {
            gameAttributes = this.dao.getList(GameAttributes.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (gameAttributes == null ? "null" : Integer.valueOf(gameAttributes.size()))));
        return gameAttributes;
    }

    public List<Long> getGameAttributesIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGameAttributesIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGameAttributesIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getGameAttributesIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getGameAttributesIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long getGameAttributesIdByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name  : " + name));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getGameAttributesIdByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getGameAttributesIdsByGidAndType(Long gid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by gid,type,start,limit  : " + gid + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGameAttributesIdsByGidAndType", new Object[]{gid, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by gid,type,start,limit)  : " + gid + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGameAttributesIdsByGidAndType(Long gid, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by gid,type  : " + gid + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGameAttributesIdsByGidAndType", new Object[]{gid, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by gid,type)  : " + gid + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getGameAttributesIdsByGid(Long gid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by gid,start,limit  : " + gid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGameAttributesIdsByGid", new Object[]{gid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by gid,start,limit)  : " + gid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getGameAttributesIdByNameAndType(String name, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name,type  : " + name + " , " + type));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getGameAttributesIdByNameAndType", new Object[]{name, type});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name,type  : " + name + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }
}

