/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.Surrounding;
import com.ptteng.goldwind.common.service.SurroundingService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SurroundingServiceImpl
extends BaseDaoServiceImpl
implements SurroundingService {
    private static final Log log = LogFactory.getLog(SurroundingServiceImpl.class);

    public Long insert(Surrounding surrounding) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + surrounding));
        if (surrounding == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        surrounding.setCreateAt(Long.valueOf(currentTimeMillis));
        surrounding.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)surrounding);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + surrounding));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Surrounding> insertList(List<Surrounding> surroundingList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (surroundingList == null ? "null" : Integer.valueOf(surroundingList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(surroundingList)) {
            return new ArrayList<Surrounding>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Surrounding surrounding : surroundingList) {
            surrounding.setCreateAt(Long.valueOf(currentTimeMillis));
            surrounding.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(surroundingList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + surroundingList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Surrounding.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Surrounding surrounding) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (surrounding == null ? "null" : surrounding.getId())));
        boolean result = false;
        if (surrounding == null) {
            return true;
        }
        surrounding.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)surrounding);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + surrounding));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + surrounding));
        }
        return result;
    }

    public boolean updateList(List<Surrounding> surroundingList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (surroundingList == null ? "null" : Integer.valueOf(surroundingList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(surroundingList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Surrounding surrounding : surroundingList) {
            surrounding.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(surroundingList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + surroundingList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + surroundingList.size()));
        return result;
    }

    public Surrounding getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Surrounding surrounding = null;
        if (id == null) {
            return surrounding;
        }
        try {
            surrounding = (Surrounding)this.dao.get(Surrounding.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return surrounding;
    }

    public List<Surrounding> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List surrounding = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Surrounding>();
        }
        try {
            surrounding = this.dao.getList(Surrounding.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (surrounding == null ? "null" : Integer.valueOf(surrounding.size()))));
        return surrounding;
    }

    public List<Long> getSurroundingIdsByStatus(Long status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSurroundingIdsByStatus", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSurroundingIdsByStatus(Long status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status  : " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getSurroundingIdsByStatus", new Object[]{status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status)  : " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getSurroundingIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSurroundingIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSurroundingIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSurroundingIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSurroundingIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

