/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.CommodityOrder;
import com.ptteng.goldwind.common.service.CommodityOrderService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommodityOrderServiceImpl
extends BaseDaoServiceImpl
implements CommodityOrderService {
    private static final Log log = LogFactory.getLog(CommodityOrderServiceImpl.class);

    public Long insert(CommodityOrder commodityOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + commodityOrder));
        if (commodityOrder == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        commodityOrder.setCreateAt(Long.valueOf(currentTimeMillis));
        commodityOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)commodityOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + commodityOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<CommodityOrder> insertList(List<CommodityOrder> commodityOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (commodityOrderList == null ? "null" : Integer.valueOf(commodityOrderList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(commodityOrderList)) {
            return new ArrayList<CommodityOrder>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (CommodityOrder commodityOrder : commodityOrderList) {
            commodityOrder.setCreateAt(Long.valueOf(currentTimeMillis));
            commodityOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(commodityOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + commodityOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(CommodityOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(CommodityOrder commodityOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (commodityOrder == null ? "null" : commodityOrder.getId())));
        boolean result = false;
        if (commodityOrder == null) {
            return true;
        }
        commodityOrder.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)commodityOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + commodityOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + commodityOrder));
        }
        return result;
    }

    public boolean updateList(List<CommodityOrder> commodityOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (commodityOrderList == null ? "null" : Integer.valueOf(commodityOrderList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(commodityOrderList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (CommodityOrder commodityOrder : commodityOrderList) {
            commodityOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(commodityOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + commodityOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + commodityOrderList.size()));
        return result;
    }

    public CommodityOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        CommodityOrder commodityOrder = null;
        if (id == null) {
            return commodityOrder;
        }
        try {
            commodityOrder = (CommodityOrder)this.dao.get(CommodityOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return commodityOrder;
    }

    public List<CommodityOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List commodityOrder = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<CommodityOrder>();
        }
        try {
            commodityOrder = this.dao.getList(CommodityOrder.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (commodityOrder == null ? "null" : Integer.valueOf(commodityOrder.size()))));
        return commodityOrder;
    }

    public List<Long> getCommodityOrderIdsByMobile(String mobile, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by mobile,start,limit  : " + mobile + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCommodityOrderIdsByMobile", new Object[]{mobile}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by mobile,start,limit)  : " + mobile + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getCommodityOrderIdsByUserId(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by userId,start,limit  : " + userId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCommodityOrderIdsByUserId", new Object[]{userId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by userId,start,limit)  : " + userId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getCommodityOrderIdsByStatusAndUserId(Integer status, Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,userId,start,limit  : " + status + " , " + userId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCommodityOrderIdsByStatusAndUserId", new Object[]{status, userId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,userId,start,limit)  : " + status + " , " + userId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCommodityOrderIdsByMobile(String mobile) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by mobile  : " + mobile));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCommodityOrderIdsByMobile", new Object[]{mobile});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by mobile)  : " + mobile));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countCommodityOrderIdsByUserId(Long userId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by userId  : " + userId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCommodityOrderIdsByUserId", new Object[]{userId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by userId)  : " + userId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countCommodityOrderIdsByStatusAndUserId(Integer status, Long userId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status,userId  : " + status + " , " + userId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCommodityOrderIdsByStatusAndUserId", new Object[]{status, userId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status,userId)  : " + status + " , " + userId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getCommodityOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCommodityOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCommodityOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCommodityOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCommodityOrderIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

