/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.CallCenter;
import com.ptteng.goldwind.common.service.CallCenterService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallCenterServiceImpl
extends BaseDaoServiceImpl
implements CallCenterService {
    private static final Log log = LogFactory.getLog(CallCenterServiceImpl.class);

    public Long insert(CallCenter callCenter) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + callCenter));
        if (callCenter == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        callCenter.setCreateAt(Long.valueOf(currentTimeMillis));
        callCenter.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)callCenter);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + callCenter));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<CallCenter> insertList(List<CallCenter> callCenterList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (callCenterList == null ? "null" : Integer.valueOf(callCenterList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(callCenterList)) {
            return new ArrayList<CallCenter>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (CallCenter callCenter : callCenterList) {
            callCenter.setCreateAt(Long.valueOf(currentTimeMillis));
            callCenter.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(callCenterList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + callCenterList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(CallCenter.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(CallCenter callCenter) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (callCenter == null ? "null" : callCenter.getId())));
        boolean result = false;
        if (callCenter == null) {
            return true;
        }
        callCenter.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)callCenter);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + callCenter));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + callCenter));
        }
        return result;
    }

    public boolean updateList(List<CallCenter> callCenterList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (callCenterList == null ? "null" : Integer.valueOf(callCenterList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(callCenterList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (CallCenter callCenter : callCenterList) {
            callCenter.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(callCenterList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + callCenterList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + callCenterList.size()));
        return result;
    }

    public CallCenter getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        CallCenter callCenter = null;
        if (id == null) {
            return callCenter;
        }
        try {
            callCenter = (CallCenter)this.dao.get(CallCenter.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return callCenter;
    }

    public List<CallCenter> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List callCenter = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<CallCenter>();
        }
        try {
            callCenter = this.dao.getList(CallCenter.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (callCenter == null ? "null" : Integer.valueOf(callCenter.size()))));
        return callCenter;
    }

    public List<Long> getCallCenterIdsByServcieId(Long servcieId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by servcieId,start,limit  : " + servcieId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCallCenterIdsByServcieId", new Object[]{servcieId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by servcieId,start,limit)  : " + servcieId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCallCenterIdsByServcieId(Long servcieId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by servcieId  : " + servcieId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCallCenterIdsByServcieId", new Object[]{servcieId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by servcieId)  : " + servcieId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getCallCenterIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCallCenterIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCallCenterIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCallCenterIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCallCenterIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

