/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.Appointment;
import com.ptteng.goldwind.common.service.AppointmentService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppointmentServiceImpl
extends BaseDaoServiceImpl
implements AppointmentService {
    private static final Log log = LogFactory.getLog(AppointmentServiceImpl.class);

    public Long insert(Appointment appointment) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + appointment));
        if (appointment == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        appointment.setCreateAt(Long.valueOf(currentTimeMillis));
        appointment.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)appointment);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + appointment));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Appointment> insertList(List<Appointment> appointmentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (appointmentList == null ? "null" : Integer.valueOf(appointmentList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(appointmentList)) {
            return new ArrayList<Appointment>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Appointment appointment : appointmentList) {
            appointment.setCreateAt(Long.valueOf(currentTimeMillis));
            appointment.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(appointmentList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + appointmentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Appointment.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Appointment appointment) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (appointment == null ? "null" : appointment.getId())));
        boolean result = false;
        if (appointment == null) {
            return true;
        }
        appointment.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)appointment);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + appointment));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + appointment));
        }
        return result;
    }

    public boolean updateList(List<Appointment> appointmentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (appointmentList == null ? "null" : Integer.valueOf(appointmentList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(appointmentList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Appointment appointment : appointmentList) {
            appointment.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(appointmentList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + appointmentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + appointmentList.size()));
        return result;
    }

    public Appointment getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Appointment appointment = null;
        if (id == null) {
            return appointment;
        }
        try {
            appointment = (Appointment)this.dao.get(Appointment.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return appointment;
    }

    public List<Appointment> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List appointment = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Appointment>();
        }
        try {
            appointment = this.dao.getList(Appointment.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (appointment == null ? "null" : Integer.valueOf(appointment.size()))));
        return appointment;
    }

    public List<Long> getAppointmentIdsByUId(Long uId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uId,start,limit  : " + uId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAppointmentIdsByUId", new Object[]{uId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uId,start,limit)  : " + uId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countAppointmentIdsByUId(Long uId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uId  : " + uId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getAppointmentIdsByUId", new Object[]{uId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uId)  : " + uId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getAppointmentIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAppointmentIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countAppointmentIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getAppointmentIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getAppointmentIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

