package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.Surrounding;
import com.ptteng.goldwind.common.service.SurroundingService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class SurroundingServiceImpl extends BaseDaoServiceImpl implements SurroundingService {

 

	private static final Log log = LogFactory.getLog(SurroundingServiceImpl.class);



		   
		@Override
		public Long insert(Surrounding surrounding)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + surrounding);

		if (surrounding == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		surrounding.setCreateAt(currentTimeMillis);
		surrounding.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(surrounding);
		} catch (DaoException e) {
			log.error(" insert wrong : " + surrounding);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Surrounding> insertList(List<Surrounding> surroundingList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (surroundingList == null ? "null" : surroundingList.size()));
      
		List<Surrounding> resultList = null;

		if (CollectionUtils.isEmpty(surroundingList)) {
			return new ArrayList<Surrounding>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Surrounding surrounding : surroundingList) {
			surrounding.setCreateAt(currentTimeMillis);
			surrounding.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Surrounding>) dao.batchSave(surroundingList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + surroundingList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Surrounding.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Surrounding surrounding)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (surrounding == null ? "null" : surrounding.getId()));

		boolean result = false;

		if (surrounding == null) {
			return true;
		}

		surrounding.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(surrounding);
		} catch (DaoException e) {
			log.error(" update wrong : " + surrounding);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + surrounding);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Surrounding> surroundingList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (surroundingList == null ? "null" : surroundingList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(surroundingList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Surrounding surrounding : surroundingList) {
			surrounding.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(surroundingList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + surroundingList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + surroundingList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Surrounding getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Surrounding surrounding = null;

		if (id == null) {
			return surrounding;
		}

		try {
			surrounding = (Surrounding) dao.get(Surrounding.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return surrounding;		
		}	
		  
    	   
		@Override
		public List<Surrounding> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Surrounding> surrounding = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Surrounding>();
		}

		try {
			surrounding = (List<Surrounding>) dao.getList(Surrounding.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (surrounding == null ? "null" : surrounding.size()));
    
		return surrounding;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSurroundingIdsByStatus(Long status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by status,start,limit  : " + status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getSurroundingIdsByStatus", new Object[] { status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by status,start,limit)  : " + status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSurroundingIdsByStatus(Long status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by status  : " + status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getSurroundingIdsByStatus", new Object[] { status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by status)  : " + status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getSurroundingIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getSurroundingIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countSurroundingIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getSurroundingIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getSurroundingIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

