package com.ptteng.goldwind.common.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.goldwind.common.model.ServiceStation;
import com.ptteng.goldwind.common.service.ServiceStationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ServiceStationServiceImpl extends BaseDaoServiceImpl implements ServiceStationService {



	private static final Log log = LogFactory.getLog(ServiceStationServiceImpl.class);




	@Override
	public Long insert(ServiceStation serviceStation)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + serviceStation);

		if (serviceStation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		serviceStation.setCreateAt(currentTimeMillis);
		serviceStation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(serviceStation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + serviceStation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<ServiceStation> insertList(List<ServiceStation> serviceStationList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (serviceStationList == null ? "null" : serviceStationList.size()));

		List<ServiceStation> resultList = null;

		if (CollectionUtils.isEmpty(serviceStationList)) {
			return new ArrayList<ServiceStation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ServiceStation serviceStation : serviceStationList) {
			serviceStation.setCreateAt(currentTimeMillis);
			serviceStation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<ServiceStation>) dao.batchSave(serviceStationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + serviceStationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(ServiceStation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(ServiceStation serviceStation)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (serviceStation == null ? "null" : serviceStation.getId()));

		boolean result = false;

		if (serviceStation == null) {
			return true;
		}

		serviceStation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(serviceStation);
		} catch (DaoException e) {
			log.error(" update wrong : " + serviceStation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + serviceStation);
		}
		return result;
	}


	@Override
	public boolean updateList(List<ServiceStation> serviceStationList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (serviceStationList == null ? "null" : serviceStationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(serviceStationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ServiceStation serviceStation : serviceStationList) {
			serviceStation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(serviceStationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + serviceStationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + serviceStationList.size());

		return result;
	}


	@Override
	public ServiceStation getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		ServiceStation serviceStation = null;

		if (id == null) {
			return serviceStation;
		}

		try {
			serviceStation = (ServiceStation) dao.get(ServiceStation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return serviceStation;
	}


	@Override
	public List<ServiceStation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<ServiceStation> serviceStation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<ServiceStation>();
		}

		try {
			serviceStation = (List<ServiceStation>) dao.getList(ServiceStation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (serviceStation == null ? "null" : serviceStation.size()));

		return serviceStation;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getServiceStationIdsByTelephone(String telephone,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by telephone,start,limit  : " + telephone+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getServiceStationIdsByTelephone", new Object[] { telephone},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by telephone,start,limit)  : " + telephone+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getServiceStationIdsByStatus(Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by status,start,limit  : " + status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getServiceStationIdsByStatus", new Object[] { status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by status,start,limit)  : " + status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getServiceStationIdsByStatusAndTelephone(Integer status,String telephone,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by status,telephone,start,limit  : " + status+" , "+telephone+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getServiceStationIdsByStatusAndTelephone", new Object[] { status,telephone},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by status,telephone,start,limit)  : " + status+" , "+telephone+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getServiceStationIdsByName(String name,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by name,start,limit  : " + name+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getServiceStationIdsByName", new Object[] { name},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by name,start,limit)  : " + name+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countServiceStationIdsByTelephone(String telephone)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by telephone  : " + telephone );
		}
		Integer count=null;



		try {

			count = dao.count("getServiceStationIdsByTelephone", new Object[] { telephone});


		} catch (DaoException e) {
			log.error(" count ids  wrong by telephone)  : " + telephone );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countServiceStationIdsByStatus(Integer status)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by status  : " + status );
		}
		Integer count=null;



		try {

			count = dao.count("getServiceStationIdsByStatus", new Object[] { status});


		} catch (DaoException e) {
			log.error(" count ids  wrong by status)  : " + status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countServiceStationIdsByStatusAndTelephone(Integer status,String telephone)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by status,telephone  : " + status+" , "+telephone );
		}
		Integer count=null;



		try {

			count = dao.count("getServiceStationIdsByStatusAndTelephone", new Object[] { status,telephone});


		} catch (DaoException e) {
			log.error(" count ids  wrong by status,telephone)  : " + status+" , "+telephone );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countServiceStationIdsByName(String name)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by name  : " + name );
		}
		Integer count=null;



		try {

			count = dao.count("getServiceStationIdsByName", new Object[] { name});


		} catch (DaoException e) {
			log.error(" count ids  wrong by name)  : " + name );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getServiceStationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getServiceStationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countServiceStationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getServiceStationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getServiceStationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

