package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.ProductDir;
import com.ptteng.goldwind.common.service.ProductDirService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ProductDirServiceImpl extends BaseDaoServiceImpl implements ProductDirService {

 

	private static final Log log = LogFactory.getLog(ProductDirServiceImpl.class);



		   
		@Override
		public Long insert(ProductDir productDir)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + productDir);

		if (productDir == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		productDir.setCreateAt(currentTimeMillis);
		productDir.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(productDir);
		} catch (DaoException e) {
			log.error(" insert wrong : " + productDir);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<ProductDir> insertList(List<ProductDir> productDirList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (productDirList == null ? "null" : productDirList.size()));
      
		List<ProductDir> resultList = null;

		if (CollectionUtils.isEmpty(productDirList)) {
			return new ArrayList<ProductDir>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ProductDir productDir : productDirList) {
			productDir.setCreateAt(currentTimeMillis);
			productDir.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<ProductDir>) dao.batchSave(productDirList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + productDirList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(ProductDir.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(ProductDir productDir)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (productDir == null ? "null" : productDir.getId()));

		boolean result = false;

		if (productDir == null) {
			return true;
		}

		productDir.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(productDir);
		} catch (DaoException e) {
			log.error(" update wrong : " + productDir);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + productDir);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<ProductDir> productDirList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (productDirList == null ? "null" : productDirList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(productDirList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ProductDir productDir : productDirList) {
			productDir.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(productDirList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + productDirList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + productDirList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public ProductDir getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		ProductDir productDir = null;

		if (id == null) {
			return productDir;
		}

		try {
			productDir = (ProductDir) dao.get(ProductDir.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return productDir;		
		}	
		  
    	   
		@Override
		public List<ProductDir> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<ProductDir> productDir = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<ProductDir>();
		}

		try {
			productDir = (List<ProductDir>) dao.getList(ProductDir.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (productDir == null ? "null" : productDir.size()));
    
		return productDir;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProductDirIdsByDirIdAndStatus(Long dirId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by dirId,status,start,limit  : " + dirId+" , "+status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getProductDirIdsByDirIdAndStatus", new Object[] { dirId,status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by dirId,status,start,limit)  : " + dirId+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProductDirIdsByDirId(Long dirId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by dirId,start,limit  : " + dirId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getProductDirIdsByDirId", new Object[] { dirId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by dirId,start,limit)  : " + dirId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProductDirIdsByDirIdAndStatus(Long dirId,Integer status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by dirId,status  : " + dirId+" , "+status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getProductDirIdsByDirIdAndStatus", new Object[] { dirId,status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by dirId,status)  : " + dirId+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProductDirIdsByDirId(Long dirId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by dirId  : " + dirId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getProductDirIdsByDirId", new Object[] { dirId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by dirId)  : " + dirId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getProductDirIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getProductDirIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countProductDirIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getProductDirIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getProductDirIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

