package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.goldwind.common.bean.yl.QueryBean;
import com.ptteng.goldwind.common.bean.yl.RequestBean;
import com.ptteng.goldwind.common.service.PayOrderService;
import com.ptteng.goldwind.common.util.yl.PayUtil;
import com.ptteng.goldwind.common.util.yl.RemoteAccessor;
import com.ptteng.goldwind.common.bean.yl.QueryBean;
import com.ptteng.goldwind.common.bean.yl.RequestBean;
import com.ptteng.goldwind.common.service.PayOrderService;
import com.ptteng.goldwind.common.util.yl.PayUtil;
import com.ptteng.goldwind.common.util.yl.RemoteAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Map;

/**
 * 支付
 *
 * @author magenm
 *
 */

public class PayOrderServiceImpl implements PayOrderService {

	private static final Log log = LogFactory.getLog(PayOrderServiceImpl.class);

	private Map<String, String> payConfig;

	public Map<String, String> getPayConfig() {
		return payConfig;
	}

	public void setPayConfig(Map<String, String> payConfig) {
		this.payConfig = payConfig;
	}

	public static void main(String[] args) {
		String xmlString = "";
	}

	/**
	 * 支付状态监测
	 */
	@Override
	public String check(String merchantOrderId, String merchantOrderTime ,String type)
		{
		// TODO Auto-generated method stub

		log.info("merchantOrderId=" + merchantOrderId + ",merchantOrderTime="
				+ merchantOrderTime);

		QueryBean que = new QueryBean();
		que.setTransType("01");
		que.setMerchantOrderId(merchantOrderId);
		que.setMerchantId(payConfig.get("merchantId"));
//		req.setMerchantName(payConfig.get("merchantName"));
//		que.setFrontUrl(payConfig.get("frontUrl")+"/"+merchantOrderId);
		que.setMerchantOrderTime(merchantOrderTime);

//		que.setMerchantOrderId(merchantOrderId);


//		req.setMerchantOrderCurrency(payConfig.get("merchantOrderCurrency"));
//		req.setGwType(payConfig.get("gwType"));
//		req.setBackUrl(payConfig.get("backUrl")+"/"+merchantOrderId);
//
//		req.setMerchantOrderId(merchantOrderId);
//		req.setMerchantOrderAmt(merchantOrderAmt);
//		req.setMerchantOrderDesc(merchantOrderDesc);
//
		String data = que.doc2String(que.toDocument());
		String xml = PayUtil.getData(data, que.getMerchantId(),
				payConfig.get("key"), payConfig.get("keyFile"));

		log.info("xml:" + xml);



		try {
			RemoteAccessor remoteAccessor = new RemoteAccessor();
			String re = remoteAccessor.getResponseByStream(
					payConfig.get("payUrl"), "utf-8", xml);
			log.info("query resault:"+re);
			return PayUtil.responseQueryCheck(re, payConfig.get("key"));

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error("pay  error : " + e.getMessage());

			return null;
		}
	}

	@Override
	public String checkPayment(String merchantOrderId, String merchantOrderTime, String type) {
		return null;
	}

	@Override
	public String payTest(String code,String type) {
		return null;
	}

	/**
	 * 支付
	 */
	@Override
	public String pay(String userid,String merchantOrderId, String merchantOrderTime,String merchantOrderName,
			String merchantOrderAmt, String merchantOrderDesc,String frontUrl,String backUrl,String type)
 {
		// TODO Auto-generated method stub

		log.info("merchantOrderId=" + merchantOrderId + ",merchantOrderTime="
				+ merchantOrderTime + ",merchantOrderAmt=" + merchantOrderAmt
				+ ",merchantOrderDesc=" + merchantOrderDesc);

		RequestBean req = new RequestBean();
		req.setApplication("MGw.Req");
		req.setMerchantId(payConfig.get("merchantId"));
		req.setMerchantName(payConfig.get("merchantName"));
		req.setMerchantOrderCurrency(payConfig.get("merchantOrderCurrency"));
		req.setGwType(payConfig.get("gwType"));
		req.setTransTimeout(payConfig.get("transTimeout"));

		req.setFrontUrl(frontUrl+"/"+merchantOrderId);
		req.setBackUrl(backUrl+"/"+merchantOrderId);

		req.setMerchantOrderId(merchantOrderId);
		req.setMerchantOrderAmt(merchantOrderAmt);
		req.setMerchantOrderTime(merchantOrderTime);
		req.setMerchantOrderDesc(merchantOrderDesc);

		String data = req.doc2String(req.toDocument());
		String xml = PayUtil.getData(data, req.getMerchantId(),
				payConfig.get("key"), payConfig.get("keyFile"));

		log.info("xml:" + xml);
		try {
			RemoteAccessor remoteAccessor = new RemoteAccessor();
			String re = remoteAccessor.getResponseByStream(
					payConfig.get("payUrl"), "utf-8", xml);

			return PayUtil.getUrl(re, payConfig.get("key"));
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			log.error("pay  error : " + e.getMessage());

			return null;
		}
	}

	@Override
	public String pyPay(String order_no, String to_bank_no, String to_acct_no, String to_acct_name, String acct_type, String trans_amt, String trans_usage, String type) {
		return null;
	}

	/**
	 * 解析通知报文
	 *
	 * @param xmlString
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public String notice(String xmlString,String type) {

		return PayUtil.getNotice(xmlString, payConfig.get("publicKey"), payConfig.get("publicKeyFile"));

	}

	@Override
	public boolean ylnotice(Map<String, String> reqData, String encoding, String type){
		return false;
	}

	@Override
	public String getParam(String key,String type)  {
		// TODO Auto-generated method stub
		return payConfig.get(key);
	}

	@Override
	public String epAuthSyncWithSms(String trac_no, String acct_type, String bank_no, String card_no, String user_name, String cert_no, String card_phone, String expireDate, String cvn,String type) {
		return null;
	}

	@Override
	public String epAuthCheckSms(String trac_no, String sms_code,String type) {
		return null;
	}

	@Override
	public String epAuthQuery(String trac_no, String type) {
		return null;
	}

}
