package com.ptteng.goldwind.common.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.goldwind.common.model.Orders;
import com.ptteng.goldwind.common.service.OrdersService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class OrdersServiceImpl extends BaseDaoServiceImpl implements OrdersService {



	private static final Log log = LogFactory.getLog(OrdersServiceImpl.class);




	@Override
	public Long insert(Orders orders)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + orders);

		if (orders == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		orders.setCreateAt(currentTimeMillis);
		orders.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(orders);
		} catch (DaoException e) {
			log.error(" insert wrong : " + orders);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<Orders> insertList(List<Orders> ordersList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (ordersList == null ? "null" : ordersList.size()));

		List<Orders> resultList = null;

		if (CollectionUtils.isEmpty(ordersList)) {
			return new ArrayList<Orders>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Orders orders : ordersList) {
			orders.setCreateAt(currentTimeMillis);
			orders.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Orders>) dao.batchSave(ordersList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + ordersList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Orders.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(Orders orders)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (orders == null ? "null" : orders.getId()));

		boolean result = false;

		if (orders == null) {
			return true;
		}

		orders.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(orders);
		} catch (DaoException e) {
			log.error(" update wrong : " + orders);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + orders);
		}
		return result;
	}


	@Override
	public boolean updateList(List<Orders> ordersList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (ordersList == null ? "null" : ordersList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(ordersList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Orders orders : ordersList) {
			orders.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(ordersList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + ordersList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + ordersList.size());

		return result;
	}


	@Override
	public Orders getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		Orders orders = null;

		if (id == null) {
			return orders;
		}

		try {
			orders = (Orders) dao.get(Orders.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return orders;
	}


	@Override
	public List<Orders> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<Orders> orders = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Orders>();
		}

		try {
			orders = (List<Orders>) dao.getList(Orders.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (orders == null ? "null" : orders.size()));

		return orders;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getOrdersIdsByMobile(String mobile,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by mobile,start,limit  : " + mobile+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getOrdersIdsByMobile", new Object[] { mobile},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by mobile,start,limit)  : " + mobile+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getOrdersIdsByAccount(String account,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by account,start,limit  : " + account+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getOrdersIdsByAccount", new Object[] { account},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by account,start,limit)  : " + account+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getOrdersIdsByUIdAndStatus(Long uId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by uId,status,start,limit  : " + uId+" , "+status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getOrdersIdsByUIdAndStatus", new Object[] { uId,status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uId,status,start,limit)  : " + uId+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countOrdersIdsByMobile(String mobile)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by mobile  : " + mobile );
		}
		Integer count=null;



		try {

			count = dao.count("getOrdersIdsByMobile", new Object[] { mobile});


		} catch (DaoException e) {
			log.error(" count ids  wrong by mobile)  : " + mobile );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countOrdersIdsByAccount(String account)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by account  : " + account );
		}
		Integer count=null;



		try {

			count = dao.count("getOrdersIdsByAccount", new Object[] { account});


		} catch (DaoException e) {
			log.error(" count ids  wrong by account)  : " + account );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countOrdersIdsByUIdAndStatus(Long uId,Integer status)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by uId,status  : " + uId+" , "+status );
		}
		Integer count=null;



		try {

			count = dao.count("getOrdersIdsByUIdAndStatus", new Object[] { uId,status});


		} catch (DaoException e) {
			log.error(" count ids  wrong by uId,status)  : " + uId+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getOrdersIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getOrdersIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countOrdersIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getOrdersIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getOrdersIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

