package com.ptteng.goldwind.common.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.goldwind.common.model.OrderProduct;
import com.ptteng.goldwind.common.service.OrderProductService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class OrderProductServiceImpl extends BaseDaoServiceImpl implements OrderProductService {



	private static final Log log = LogFactory.getLog(OrderProductServiceImpl.class);




	@Override
	public Long insert(OrderProduct orderProduct)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + orderProduct);

		if (orderProduct == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		orderProduct.setCreateAt(currentTimeMillis);
		orderProduct.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(orderProduct);
		} catch (DaoException e) {
			log.error(" insert wrong : " + orderProduct);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<OrderProduct> insertList(List<OrderProduct> orderProductList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (orderProductList == null ? "null" : orderProductList.size()));

		List<OrderProduct> resultList = null;

		if (CollectionUtils.isEmpty(orderProductList)) {
			return new ArrayList<OrderProduct>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (OrderProduct orderProduct : orderProductList) {
			orderProduct.setCreateAt(currentTimeMillis);
			orderProduct.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<OrderProduct>) dao.batchSave(orderProductList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + orderProductList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(OrderProduct.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(OrderProduct orderProduct)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (orderProduct == null ? "null" : orderProduct.getId()));

		boolean result = false;

		if (orderProduct == null) {
			return true;
		}

		orderProduct.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(orderProduct);
		} catch (DaoException e) {
			log.error(" update wrong : " + orderProduct);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + orderProduct);
		}
		return result;
	}


	@Override
	public boolean updateList(List<OrderProduct> orderProductList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (orderProductList == null ? "null" : orderProductList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(orderProductList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (OrderProduct orderProduct : orderProductList) {
			orderProduct.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(orderProductList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + orderProductList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + orderProductList.size());

		return result;
	}


	@Override
	public OrderProduct getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		OrderProduct orderProduct = null;

		if (id == null) {
			return orderProduct;
		}

		try {
			orderProduct = (OrderProduct) dao.get(OrderProduct.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return orderProduct;
	}


	@Override
	public List<OrderProduct> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<OrderProduct> orderProduct = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<OrderProduct>();
		}

		try {
			orderProduct = (List<OrderProduct>) dao.getList(OrderProduct.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (orderProduct == null ? "null" : orderProduct.size()));

		return orderProduct;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getOrderProductIdsByOrderId(Long orderId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by orderId,start,limit  : " + orderId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getOrderProductIdsByOrderId", new Object[] { orderId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by orderId,start,limit)  : " + orderId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getOrderProductIdsByOrderIdAndStatus(Long orderId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by orderId,status,start,limit  : " + orderId+" , "+status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getOrderProductIdsByOrderIdAndStatus", new Object[] { orderId,status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by orderId,status,start,limit)  : " + orderId+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countOrderProductIdsByOrderId(Long orderId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by orderId  : " + orderId );
		}
		Integer count=null;



		try {

			count = dao.count("getOrderProductIdsByOrderId", new Object[] { orderId});


		} catch (DaoException e) {
			log.error(" count ids  wrong by orderId)  : " + orderId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countOrderProductIdsByOrderIdAndStatus(Long orderId,Integer status)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by orderId,status  : " + orderId+" , "+status );
		}
		Integer count=null;



		try {

			count = dao.count("getOrderProductIdsByOrderIdAndStatus", new Object[] { orderId,status});


		} catch (DaoException e) {
			log.error(" count ids  wrong by orderId,status)  : " + orderId+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getOrderProductIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getOrderProductIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countOrderProductIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getOrderProductIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getOrderProductIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

