package com.ptteng.goldwind.common.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.goldwind.common.model.Favorite;
import com.ptteng.goldwind.common.service.FavoriteService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class FavoriteServiceImpl extends BaseDaoServiceImpl implements FavoriteService {



	private static final Log log = LogFactory.getLog(FavoriteServiceImpl.class);




	@Override
	public Long insert(Favorite favorite)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + favorite);

		if (favorite == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		favorite.setCreateAt(currentTimeMillis);
		favorite.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(favorite);
		} catch (DaoException e) {
			log.error(" insert wrong : " + favorite);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<Favorite> insertList(List<Favorite> favoriteList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (favoriteList == null ? "null" : favoriteList.size()));

		List<Favorite> resultList = null;

		if (CollectionUtils.isEmpty(favoriteList)) {
			return new ArrayList<Favorite>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Favorite favorite : favoriteList) {
			favorite.setCreateAt(currentTimeMillis);
			favorite.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Favorite>) dao.batchSave(favoriteList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + favoriteList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Favorite.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(Favorite favorite)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (favorite == null ? "null" : favorite.getId()));

		boolean result = false;

		if (favorite == null) {
			return true;
		}

		favorite.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(favorite);
		} catch (DaoException e) {
			log.error(" update wrong : " + favorite);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + favorite);
		}
		return result;
	}


	@Override
	public boolean updateList(List<Favorite> favoriteList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (favoriteList == null ? "null" : favoriteList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(favoriteList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Favorite favorite : favoriteList) {
			favorite.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(favoriteList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + favoriteList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + favoriteList.size());

		return result;
	}


	@Override
	public Favorite getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		Favorite favorite = null;

		if (id == null) {
			return favorite;
		}

		try {
			favorite = (Favorite) dao.get(Favorite.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return favorite;
	}


	@Override
	public List<Favorite> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<Favorite> favorite = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Favorite>();
		}

		try {
			favorite = (List<Favorite>) dao.getList(Favorite.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (favorite == null ? "null" : favorite.size()));

		return favorite;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getFavoriteIdsByUId(Long uId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by uId,start,limit  : " + uId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getFavoriteIdsByUId", new Object[] { uId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uId,start,limit)  : " + uId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getFavoriteIdsByUIdAndTargetId(Long uId,Long targetId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by uId,targetId,start,limit  : " + uId+" , "+targetId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getFavoriteIdsByUIdAndTargetId", new Object[] { uId,targetId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uId,targetId,start,limit)  : " + uId+" , "+targetId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countFavoriteIdsByUId(Long uId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by uId  : " + uId );
		}
		Integer count=null;



		try {

			count = dao.count("getFavoriteIdsByUId", new Object[] { uId});


		} catch (DaoException e) {
			log.error(" count ids  wrong by uId)  : " + uId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countFavoriteIdsByUIdAndTargetId(Long uId,Long targetId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by uId,targetId  : " + uId+" , "+targetId );
		}
		Integer count=null;



		try {

			count = dao.count("getFavoriteIdsByUIdAndTargetId", new Object[] { uId,targetId});


		} catch (DaoException e) {
			log.error(" count ids  wrong by uId,targetId)  : " + uId+" , "+targetId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getFavoriteIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getFavoriteIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countFavoriteIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getFavoriteIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getFavoriteIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

