package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.Commodity;
import com.ptteng.goldwind.common.service.CommodityService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class CommodityServiceImpl extends BaseDaoServiceImpl implements CommodityService {

 

	private static final Log log = LogFactory.getLog(CommodityServiceImpl.class);



		   
		@Override
		public Long insert(Commodity commodity)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + commodity);

		if (commodity == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		commodity.setCreateAt(currentTimeMillis);
		commodity.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(commodity);
		} catch (DaoException e) {
			log.error(" insert wrong : " + commodity);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Commodity> insertList(List<Commodity> commodityList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (commodityList == null ? "null" : commodityList.size()));
      
		List<Commodity> resultList = null;

		if (CollectionUtils.isEmpty(commodityList)) {
			return new ArrayList<Commodity>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Commodity commodity : commodityList) {
			commodity.setCreateAt(currentTimeMillis);
			commodity.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Commodity>) dao.batchSave(commodityList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + commodityList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Commodity.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Commodity commodity)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (commodity == null ? "null" : commodity.getId()));

		boolean result = false;

		if (commodity == null) {
			return true;
		}

		commodity.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(commodity);
		} catch (DaoException e) {
			log.error(" update wrong : " + commodity);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + commodity);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Commodity> commodityList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (commodityList == null ? "null" : commodityList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(commodityList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Commodity commodity : commodityList) {
			commodity.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(commodityList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + commodityList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + commodityList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Commodity getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Commodity commodity = null;

		if (id == null) {
			return commodity;
		}

		try {
			commodity = (Commodity) dao.get(Commodity.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return commodity;		
		}	
		  
    	   
		@Override
		public List<Commodity> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Commodity> commodity = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Commodity>();
		}

		try {
			commodity = (List<Commodity>) dao.getList(Commodity.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (commodity == null ? "null" : commodity.size()));
    
		return commodity;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCommodityIdsByAccount(String account,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by account,start,limit  : " + account+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getCommodityIdsByAccount", new Object[] { account},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by account,start,limit)  : " + account+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCommodityIdsByAccount(String account)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by account  : " + account );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getCommodityIdsByAccount", new Object[] { account});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by account)  : " + account );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getCommodityIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getCommodityIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countCommodityIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getCommodityIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getCommodityIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

