package com.ptteng.goldwind.common.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.goldwind.common.model.CommodityOrder;
import com.ptteng.goldwind.common.service.CommodityOrderService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class CommodityOrderServiceImpl extends BaseDaoServiceImpl implements CommodityOrderService {



	private static final Log log = LogFactory.getLog(CommodityOrderServiceImpl.class);




	@Override
	public Long insert(CommodityOrder commodityOrder)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + commodityOrder);

		if (commodityOrder == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		commodityOrder.setCreateAt(currentTimeMillis);
		commodityOrder.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(commodityOrder);
		} catch (DaoException e) {
			log.error(" insert wrong : " + commodityOrder);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<CommodityOrder> insertList(List<CommodityOrder> commodityOrderList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (commodityOrderList == null ? "null" : commodityOrderList.size()));

		List<CommodityOrder> resultList = null;

		if (CollectionUtils.isEmpty(commodityOrderList)) {
			return new ArrayList<CommodityOrder>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (CommodityOrder commodityOrder : commodityOrderList) {
			commodityOrder.setCreateAt(currentTimeMillis);
			commodityOrder.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<CommodityOrder>) dao.batchSave(commodityOrderList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + commodityOrderList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(CommodityOrder.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(CommodityOrder commodityOrder)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (commodityOrder == null ? "null" : commodityOrder.getId()));

		boolean result = false;

		if (commodityOrder == null) {
			return true;
		}

		commodityOrder.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(commodityOrder);
		} catch (DaoException e) {
			log.error(" update wrong : " + commodityOrder);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + commodityOrder);
		}
		return result;
	}


	@Override
	public boolean updateList(List<CommodityOrder> commodityOrderList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (commodityOrderList == null ? "null" : commodityOrderList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(commodityOrderList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (CommodityOrder commodityOrder : commodityOrderList) {
			commodityOrder.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(commodityOrderList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + commodityOrderList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + commodityOrderList.size());

		return result;
	}


	@Override
	public CommodityOrder getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		CommodityOrder commodityOrder = null;

		if (id == null) {
			return commodityOrder;
		}

		try {
			commodityOrder = (CommodityOrder) dao.get(CommodityOrder.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return commodityOrder;
	}


	@Override
	public List<CommodityOrder> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<CommodityOrder> commodityOrder = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<CommodityOrder>();
		}

		try {
			commodityOrder = (List<CommodityOrder>) dao.getList(CommodityOrder.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (commodityOrder == null ? "null" : commodityOrder.size()));

		return commodityOrder;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getCommodityOrderIdsByMobile(String mobile,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by mobile,start,limit  : " + mobile+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getCommodityOrderIdsByMobile", new Object[] { mobile},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by mobile,start,limit)  : " + mobile+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getCommodityOrderIdsByUserId(Long userId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by userId,start,limit  : " + userId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getCommodityOrderIdsByUserId", new Object[] { userId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by userId,start,limit)  : " + userId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getCommodityOrderIdsByStatusAndUserId(Integer status,Long userId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by status,userId,start,limit  : " + status+" , "+userId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getCommodityOrderIdsByStatusAndUserId", new Object[] { status,userId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by status,userId,start,limit)  : " + status+" , "+userId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countCommodityOrderIdsByMobile(String mobile)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by mobile  : " + mobile );
		}
		Integer count=null;



		try {

			count = dao.count("getCommodityOrderIdsByMobile", new Object[] { mobile});


		} catch (DaoException e) {
			log.error(" count ids  wrong by mobile)  : " + mobile );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countCommodityOrderIdsByUserId(Long userId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by userId  : " + userId );
		}
		Integer count=null;



		try {

			count = dao.count("getCommodityOrderIdsByUserId", new Object[] { userId});


		} catch (DaoException e) {
			log.error(" count ids  wrong by userId)  : " + userId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countCommodityOrderIdsByStatusAndUserId(Integer status,Long userId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by status,userId  : " + status+" , "+userId );
		}
		Integer count=null;



		try {

			count = dao.count("getCommodityOrderIdsByStatusAndUserId", new Object[] { status,userId});


		} catch (DaoException e) {
			log.error(" count ids  wrong by status,userId)  : " + status+" , "+userId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getCommodityOrderIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getCommodityOrderIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countCommodityOrderIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getCommodityOrderIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getCommodityOrderIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

