package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.CallCenter;
import com.ptteng.goldwind.common.service.CallCenterService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class CallCenterServiceImpl extends BaseDaoServiceImpl implements CallCenterService {

 

	private static final Log log = LogFactory.getLog(CallCenterServiceImpl.class);



		   
		@Override
		public Long insert(CallCenter callCenter)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + callCenter);

		if (callCenter == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		callCenter.setCreateAt(currentTimeMillis);
		callCenter.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(callCenter);
		} catch (DaoException e) {
			log.error(" insert wrong : " + callCenter);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<CallCenter> insertList(List<CallCenter> callCenterList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (callCenterList == null ? "null" : callCenterList.size()));
      
		List<CallCenter> resultList = null;

		if (CollectionUtils.isEmpty(callCenterList)) {
			return new ArrayList<CallCenter>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (CallCenter callCenter : callCenterList) {
			callCenter.setCreateAt(currentTimeMillis);
			callCenter.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<CallCenter>) dao.batchSave(callCenterList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + callCenterList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(CallCenter.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(CallCenter callCenter)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (callCenter == null ? "null" : callCenter.getId()));

		boolean result = false;

		if (callCenter == null) {
			return true;
		}

		callCenter.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(callCenter);
		} catch (DaoException e) {
			log.error(" update wrong : " + callCenter);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + callCenter);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<CallCenter> callCenterList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (callCenterList == null ? "null" : callCenterList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(callCenterList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (CallCenter callCenter : callCenterList) {
			callCenter.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(callCenterList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + callCenterList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + callCenterList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public CallCenter getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		CallCenter callCenter = null;

		if (id == null) {
			return callCenter;
		}

		try {
			callCenter = (CallCenter) dao.get(CallCenter.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return callCenter;		
		}	
		  
    	   
		@Override
		public List<CallCenter> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<CallCenter> callCenter = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<CallCenter>();
		}

		try {
			callCenter = (List<CallCenter>) dao.getList(CallCenter.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (callCenter == null ? "null" : callCenter.size()));
    
		return callCenter;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCallCenterIdsByServcieId(Long servcieId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by servcieId,start,limit  : " + servcieId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getCallCenterIdsByServcieId", new Object[] { servcieId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by servcieId,start,limit)  : " + servcieId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCallCenterIdsByServcieId(Long servcieId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by servcieId  : " + servcieId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getCallCenterIdsByServcieId", new Object[] { servcieId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by servcieId)  : " + servcieId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getCallCenterIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getCallCenterIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countCallCenterIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getCallCenterIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getCallCenterIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

