package com.ptteng.goldwind.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.goldwind.common.model.Appointment;
import com.ptteng.goldwind.common.service.AppointmentService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class AppointmentServiceImpl extends BaseDaoServiceImpl implements AppointmentService {

 

	private static final Log log = LogFactory.getLog(AppointmentServiceImpl.class);



		   
		@Override
		public Long insert(Appointment appointment)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + appointment);

		if (appointment == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		appointment.setCreateAt(currentTimeMillis);
		appointment.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(appointment);
		} catch (DaoException e) {
			log.error(" insert wrong : " + appointment);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Appointment> insertList(List<Appointment> appointmentList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (appointmentList == null ? "null" : appointmentList.size()));
      
		List<Appointment> resultList = null;

		if (CollectionUtils.isEmpty(appointmentList)) {
			return new ArrayList<Appointment>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Appointment appointment : appointmentList) {
			appointment.setCreateAt(currentTimeMillis);
			appointment.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Appointment>) dao.batchSave(appointmentList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + appointmentList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Appointment.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Appointment appointment)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (appointment == null ? "null" : appointment.getId()));

		boolean result = false;

		if (appointment == null) {
			return true;
		}

		appointment.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(appointment);
		} catch (DaoException e) {
			log.error(" update wrong : " + appointment);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + appointment);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Appointment> appointmentList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (appointmentList == null ? "null" : appointmentList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(appointmentList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Appointment appointment : appointmentList) {
			appointment.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(appointmentList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + appointmentList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + appointmentList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Appointment getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Appointment appointment = null;

		if (id == null) {
			return appointment;
		}

		try {
			appointment = (Appointment) dao.get(Appointment.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return appointment;		
		}	
		  
    	   
		@Override
		public List<Appointment> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Appointment> appointment = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Appointment>();
		}

		try {
			appointment = (List<Appointment>) dao.getList(Appointment.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (appointment == null ? "null" : appointment.size()));
    
		return appointment;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getAppointmentIdsByUId(Long uId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uId,start,limit  : " + uId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getAppointmentIdsByUId", new Object[] { uId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uId,start,limit)  : " + uId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countAppointmentIdsByUId(Long uId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uId  : " + uId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getAppointmentIdsByUId", new Object[] { uId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uId)  : " + uId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getAppointmentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getAppointmentIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countAppointmentIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getAppointmentIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getAppointmentIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

