/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.gene.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.gene.common.model.Version;
import com.ptteng.gene.common.service.VersionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionServiceImpl
extends BaseDaoServiceImpl
implements VersionService {
    private static final Log log = LogFactory.getLog(VersionServiceImpl.class);

    public Long insert(Version version) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + version));
        if (version == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        version.setCreateAt(Long.valueOf(currentTimeMillis));
        version.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)version);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + version));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Version> insertList(List<Version> versionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (versionList == null ? "null" : Integer.valueOf(versionList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(versionList)) {
            return new ArrayList<Version>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Version version : versionList) {
            version.setCreateAt(Long.valueOf(currentTimeMillis));
            version.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(versionList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + versionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Version.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Version version) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (version == null ? "null" : version.getId())));
        boolean result = false;
        if (version == null) {
            return true;
        }
        version.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)version);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + version));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + version));
        }
        return result;
    }

    public boolean updateList(List<Version> versionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (versionList == null ? "null" : Integer.valueOf(versionList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(versionList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Version version : versionList) {
            version.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(versionList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + versionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + versionList.size()));
        return result;
    }

    public Version getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Version version = null;
        if (id == null) {
            return version;
        }
        try {
            version = (Version)this.dao.get(Version.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return version;
    }

    public List<Version> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List version = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Version>();
        }
        try {
            version = this.dao.getList(Version.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (version == null ? "null" : Integer.valueOf(version.size()))));
        return version;
    }

    public List<Long> getVersionIdsByOsAndVersionCodeOrderByIsForceUpdate(String os, String versionCode, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by os,versionCode,start,limit  : " + os + " , " + versionCode + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getVersionIdsByOsAndVersionCodeOrderByIsForceUpdate", new Object[]{os, versionCode}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by os,versionCode,start,limit)  : " + os + " , " + versionCode + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getVersionIdsByOs(String os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by os,start,limit  : " + os + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getVersionIdsByOs", new Object[]{os}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by os,start,limit)  : " + os + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getVersionIdsByOsOrderByVersionCode(String os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by os,start,limit  : " + os + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getVersionIdsByOsOrderByVersionCode", new Object[]{os}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by os,start,limit)  : " + os + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getVersionIdByOsAndVersionCode(String os, String code) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by os  : " + os + " code : " + code));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getVersionIdByOsAndVersionCode", new Object[]{os, code});
        }
        catch (DaoException e) {
            log.error((Object)("  get id wrong by os  : " + os + " code : " + code));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countVersionIdsByOsAndVersionCodeOrderByIsForceUpdate(String os, String versionCode) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by os,versionCode  : " + os + " , " + versionCode));
        }
        Integer count = null;
        try {
            count = this.dao.count("getVersionIdsByOsAndVersionCodeOrderByIsForceUpdate", new Object[]{os, versionCode});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by os,versionCode)  : " + os + " , " + versionCode));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getVersionIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getVersionIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countVersionIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getVersionIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getVersionIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

