/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.gene.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.gene.common.model.Feedback;
import com.ptteng.gene.common.service.FeedbackService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeedbackServiceImpl
extends BaseDaoServiceImpl
implements FeedbackService {
    private static final Log log = LogFactory.getLog(FeedbackServiceImpl.class);

    public Long insert(Feedback feedback) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + feedback));
        if (feedback == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        feedback.setCreateAt(Long.valueOf(currentTimeMillis));
        feedback.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)feedback);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + feedback));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Feedback> insertList(List<Feedback> feedbackList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (feedbackList == null ? "null" : Integer.valueOf(feedbackList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(feedbackList)) {
            return new ArrayList<Feedback>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Feedback feedback : feedbackList) {
            feedback.setCreateAt(Long.valueOf(currentTimeMillis));
            feedback.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(feedbackList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + feedbackList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Feedback.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Feedback feedback) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (feedback == null ? "null" : feedback.getId())));
        boolean result = false;
        if (feedback == null) {
            return true;
        }
        feedback.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)feedback);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + feedback));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + feedback));
        }
        return result;
    }

    public boolean updateList(List<Feedback> feedbackList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (feedbackList == null ? "null" : Integer.valueOf(feedbackList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(feedbackList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Feedback feedback : feedbackList) {
            feedback.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(feedbackList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + feedbackList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + feedbackList.size()));
        return result;
    }

    public Feedback getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Feedback feedback = null;
        if (id == null) {
            return feedback;
        }
        try {
            feedback = (Feedback)this.dao.get(Feedback.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return feedback;
    }

    public List<Feedback> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List feedback = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Feedback>();
        }
        try {
            feedback = this.dao.getList(Feedback.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (feedback == null ? "null" : Integer.valueOf(feedback.size()))));
        return feedback;
    }

    public List<Long> getFeedbackIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFeedbackIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countFeedbackIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getFeedbackIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getFeedbackIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

