-- ----------------------------
-- Table structure for `product`
-- ----------------------------
-- DROP TABLE IF EXISTS `product`;
CREATE TABLE `product` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `name` varchar(200) NOT NULL   COMMENT '产品名',  
    `img` varchar(255)    COMMENT '产品图片路径',  
    `info` varchar(600)    COMMENT '产品简介',  
    `detail` text    COMMENT '产品详情',  
    `price` varchar(200)    COMMENT '价格',  
    `status` int(3) NOT NULL   COMMENT '上下架状态，1-上架，2-下架，3-删除',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `box`
-- ----------------------------
-- DROP TABLE IF EXISTS `box`;
CREATE TABLE `box` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'ID',  
    `serial` varchar(100) NOT NULL   COMMENT '序列号',  
    `user_id` bigint    COMMENT '用户ID，对应users表的主键',  
    `status` int(3)    COMMENT '状态',  
    `pdf_url` varchar(255)    COMMENT 'PDF路径',  
    `sample_url` varchar(255)    COMMENT '样本路径',  
    `result_new` text    COMMENT '最新的检测计算结果',  
    `result_PDF` text    COMMENT '生成网页版PDF的数据',  
    `product_id` bigint NOT NULL   COMMENT '产品ID，对应product表的主键',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `classify`
-- ----------------------------
-- DROP TABLE IF EXISTS `classify`;
CREATE TABLE `classify` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `name` varchar(200) NOT NULL   COMMENT '类型名',  
    `sort_order` int(3)    COMMENT '排序编号，同类的展示顺序，数值相等则自然排序',  
    `parent_id` int(3)    COMMENT '预留字段，父id',  
    `status` int(3)    COMMENT '状态类别，1-正常，2-废弃',  
    `info` varchar(500)    COMMENT '简介',  
    `detail` text    COMMENT '详情',  
    `img` varchar(255)    COMMENT '图片',  
    `custom` text    COMMENT '自定义字段',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `item`
-- ----------------------------
-- DROP TABLE IF EXISTS `item`;
CREATE TABLE `item` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '用户ID',  
    `name` varchar(100) NOT NULL   COMMENT '项目名称',  
    `classify_id` bigint    COMMENT '类型ID',  
    `img` varchar(255)    COMMENT '图片',  
    `info` varchar(255)    COMMENT '介绍文字',  
    `custom` text    COMMENT '自定义字段',  
    `status` int(3)    COMMENT '上下架状态，1-上架，2-下架，3-删除',  
    `expound_type` int(3)    COMMENT '解释的类型，数字和文本，1-数字，2-文本',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `locus`
-- ----------------------------
-- DROP TABLE IF EXISTS `locus`;
CREATE TABLE `locus` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'ID',  
    `name` varchar(100) NOT NULL   COMMENT '位点',  
    `gene` varchar(50)    COMMENT '基因',  
    `chromosomes` varchar(50)    COMMENT '染色体',  
    `gene_type` varchar(50)    COMMENT '基因类型',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `product_item_relative`
-- ----------------------------
-- DROP TABLE IF EXISTS `product_item_relative`;
CREATE TABLE `product_item_relative` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `product_id` bigint NOT NULL   COMMENT '产品id',  
    `item_id` bigint NOT NULL   COMMENT '项目id',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `paraphrase`
-- ----------------------------
-- DROP TABLE IF EXISTS `paraphrase`;
CREATE TABLE `paraphrase` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `locus_name` varchar(100) NOT NULL   COMMENT '位点id',  
    `item_id` bigint NOT NULL   COMMENT '项目id',  
    `gene_type` varchar(50)    COMMENT '基因类型',  
    `gene_value` float(50)    COMMENT '赋值',  
    `expound` text    COMMENT '基因类型解释',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





