/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.gene.business.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.gene.business.model.ProductItemRelative;
import com.ptteng.gene.business.service.ProductItemRelativeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProductItemRelativeServiceImpl
extends BaseDaoServiceImpl
implements ProductItemRelativeService {
    private static final Log log = LogFactory.getLog(ProductItemRelativeServiceImpl.class);

    public Long insert(ProductItemRelative productItemRelative) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + productItemRelative));
        if (productItemRelative == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        productItemRelative.setCreateAt(Long.valueOf(currentTimeMillis));
        productItemRelative.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)productItemRelative);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + productItemRelative));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ProductItemRelative> insertList(List<ProductItemRelative> productItemRelativeList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (productItemRelativeList == null ? "null" : Integer.valueOf(productItemRelativeList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(productItemRelativeList)) {
            return new ArrayList<ProductItemRelative>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ProductItemRelative productItemRelative : productItemRelativeList) {
            productItemRelative.setCreateAt(Long.valueOf(currentTimeMillis));
            productItemRelative.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(productItemRelativeList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + productItemRelativeList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ProductItemRelative.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ProductItemRelative productItemRelative) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (productItemRelative == null ? "null" : productItemRelative.getId())));
        boolean result = false;
        if (productItemRelative == null) {
            return true;
        }
        productItemRelative.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)productItemRelative);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + productItemRelative));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + productItemRelative));
        }
        return result;
    }

    public boolean updateList(List<ProductItemRelative> productItemRelativeList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (productItemRelativeList == null ? "null" : Integer.valueOf(productItemRelativeList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(productItemRelativeList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ProductItemRelative productItemRelative : productItemRelativeList) {
            productItemRelative.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(productItemRelativeList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + productItemRelativeList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + productItemRelativeList.size()));
        return result;
    }

    public ProductItemRelative getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ProductItemRelative productItemRelative = null;
        if (id == null) {
            return productItemRelative;
        }
        try {
            productItemRelative = (ProductItemRelative)this.dao.get(ProductItemRelative.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return productItemRelative;
    }

    public List<ProductItemRelative> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List productItemRelative = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ProductItemRelative>();
        }
        try {
            productItemRelative = this.dao.getList(ProductItemRelative.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (productItemRelative == null ? "null" : Integer.valueOf(productItemRelative.size()))));
        return productItemRelative;
    }

    public List<Long> getProductItemRelativeIdsByProductid(Long productid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by productid,start,limit  : " + productid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductItemRelativeIdsByProductid", new Object[]{productid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by productid,start,limit)  :  , " + productid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getProductItemRelativeIdsByItemIdAndProductid(Long itemId, Long productid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by itemId,productid,start,limit  : " + itemId + " , " + productid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductItemRelativeIdsByItemIdAndProductid", new Object[]{itemId, productid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by itemId,productid,start,limit)  : " + itemId + " , " + productid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProductItemRelativeIdsByItemIdAndProductid(Long itemId, Long productid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by itemId,productid  : " + itemId + " , " + productid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProductItemRelativeIdsByItemIdAndProductid", new Object[]{itemId, productid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by itemId,productid)  : " + itemId + " , " + productid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getProductItemRelativeIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductItemRelativeIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProductItemRelativeIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getProductItemRelativeIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getProductItemRelativeIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

