/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.gene.business.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.gene.business.model.Paraphrase;
import com.ptteng.gene.business.service.ParaphraseService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParaphraseServiceImpl
extends BaseDaoServiceImpl
implements ParaphraseService {
    private static final Log log = LogFactory.getLog(ParaphraseServiceImpl.class);

    public Long insert(Paraphrase paraphrase) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + paraphrase));
        if (paraphrase == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        paraphrase.setCreateAt(Long.valueOf(currentTimeMillis));
        paraphrase.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)paraphrase);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + paraphrase));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Paraphrase> insertList(List<Paraphrase> paraphraseList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (paraphraseList == null ? "null" : Integer.valueOf(paraphraseList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(paraphraseList)) {
            return new ArrayList<Paraphrase>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Paraphrase paraphrase : paraphraseList) {
            paraphrase.setCreateAt(Long.valueOf(currentTimeMillis));
            paraphrase.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(paraphraseList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + paraphraseList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Paraphrase.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Paraphrase paraphrase) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (paraphrase == null ? "null" : paraphrase.getId())));
        boolean result = false;
        if (paraphrase == null) {
            return true;
        }
        paraphrase.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)paraphrase);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + paraphrase));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + paraphrase));
        }
        return result;
    }

    public boolean updateList(List<Paraphrase> paraphraseList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (paraphraseList == null ? "null" : Integer.valueOf(paraphraseList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(paraphraseList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Paraphrase paraphrase : paraphraseList) {
            paraphrase.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(paraphraseList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + paraphraseList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + paraphraseList.size()));
        return result;
    }

    public Paraphrase getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Paraphrase paraphrase = null;
        if (id == null) {
            return paraphrase;
        }
        try {
            paraphrase = (Paraphrase)this.dao.get(Paraphrase.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return paraphrase;
    }

    public List<Paraphrase> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List paraphrase = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Paraphrase>();
        }
        try {
            paraphrase = this.dao.getList(Paraphrase.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (paraphrase == null ? "null" : Integer.valueOf(paraphrase.size()))));
        return paraphrase;
    }

    public List<Long> getParaphraseIdsByRelationId(Long relationId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by locusName,itemId,start,limit  :  " + relationId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getParaphraseIdsByRelationId", new Object[]{relationId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by locusName,itemId,start,limit)  : " + relationId + "  , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countParaphraseIdsByLocusNameAndItemId(Long locusName, Long itemId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by locusName,itemId  : " + locusName + " , " + itemId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getParaphraseIdsByRelationId", new Object[]{locusName, itemId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by locusName,itemId)  : " + locusName + " , " + itemId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getParaphraseIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getParaphraseIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countParaphraseIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getParaphraseIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getParaphraseIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getParaphraseIdsByRelationIds(List<Object[]> relationIds) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by relationIds  :  " + relationIds));
        }
        List idsList = null;
        try {
            idsList = this.dao.getMappings((Object)1L, "getParaphraseIdsByRelationIds", relationIds);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by locusName,itemId,start,limit)  : " + relationIds));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idsList == null ? "null" : Integer.valueOf(idsList.size()))));
        }
        return idsList;
    }
}

