/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.gene.business.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.gene.business.model.Locus;
import com.ptteng.gene.business.service.LocusService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocusServiceImpl
extends BaseDaoServiceImpl
implements LocusService {
    private static final Log log = LogFactory.getLog(LocusServiceImpl.class);

    public Long insert(Locus locus) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + locus));
        if (locus == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        locus.setCreateAt(Long.valueOf(currentTimeMillis));
        locus.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)locus);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + locus));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Locus> insertList(List<Locus> locusList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (locusList == null ? "null" : Integer.valueOf(locusList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(locusList)) {
            return new ArrayList<Locus>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Locus locus : locusList) {
            locus.setCreateAt(Long.valueOf(currentTimeMillis));
            locus.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(locusList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + locusList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Locus.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Locus locus) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (locus == null ? "null" : locus.getId())));
        boolean result = false;
        if (locus == null) {
            return true;
        }
        locus.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)locus);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + locus));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + locus));
        }
        return result;
    }

    public boolean updateList(List<Locus> locusList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (locusList == null ? "null" : Integer.valueOf(locusList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(locusList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Locus locus : locusList) {
            locus.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(locusList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + locusList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + locusList.size()));
        return result;
    }

    public Locus getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Locus locus = null;
        if (id == null) {
            return locus;
        }
        try {
            locus = (Locus)this.dao.get(Locus.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return locus;
    }

    public List<Locus> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List locus = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Locus>();
        }
        try {
            locus = this.dao.getList(Locus.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (locus == null ? "null" : Integer.valueOf(locus.size()))));
        return locus;
    }

    public List<Long> getLocusIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by name,start,limit  : " + name + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLocusIdsByName", new Object[]{name}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by name,start,limit)  : " + name + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countLocusIdsByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by name  : " + name));
        }
        Integer count = null;
        try {
            count = this.dao.count("getLocusIdsByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by name)  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getLocusIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLocusIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countLocusIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getLocusIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getLocusIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getLocusIdsByLocusName(List<Object[]> locusNames, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by locusName,start,limit  : " + locusNames + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getMappings((Object)1L, "getLocusIdsByLocusName", locusNames);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by locusName,start,limit)  :  , " + locusNames + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

