/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.gene.business.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.gene.business.model.Item;
import com.ptteng.gene.business.service.ItemService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ItemServiceImpl
extends BaseDaoServiceImpl
implements ItemService {
    private static final Log log = LogFactory.getLog(ItemServiceImpl.class);

    public Long insert(Item item) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + item));
        if (item == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        item.setCreateAt(Long.valueOf(currentTimeMillis));
        item.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)item);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + item));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Item> insertList(List<Item> itemList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (itemList == null ? "null" : Integer.valueOf(itemList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(itemList)) {
            return new ArrayList<Item>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Item item : itemList) {
            item.setCreateAt(Long.valueOf(currentTimeMillis));
            item.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(itemList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + itemList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Item.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Item item) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (item == null ? "null" : item.getId())));
        boolean result = false;
        if (item == null) {
            return true;
        }
        item.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)item);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + item));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + item));
        }
        return result;
    }

    public boolean updateList(List<Item> itemList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (itemList == null ? "null" : Integer.valueOf(itemList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(itemList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Item item : itemList) {
            item.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(itemList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + itemList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + itemList.size()));
        return result;
    }

    public Item getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Item item = null;
        if (id == null) {
            return item;
        }
        try {
            item = (Item)this.dao.get(Item.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return item;
    }

    public List<Item> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List item = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Item>();
        }
        try {
            item = this.dao.getList(Item.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (item == null ? "null" : Integer.valueOf(item.size()))));
        return item;
    }

    public List<Long> getItemIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by name,start,limit  : " + name + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getItemIdsByName", new Object[]{name}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by name,start,limit)  : " + name + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getItemIdsByClassifyId(Long classifyId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by classifyId,start,limit  : " + classifyId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getItemIdsByClassifyId", new Object[]{classifyId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by classifyId,start,limit)  : " + classifyId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countItemIdsByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by name  : " + name));
        }
        Integer count = null;
        try {
            count = this.dao.count("getItemIdsByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by name)  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countItemIdsByClassifyId(Long classifyId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by classifyId  : " + classifyId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getItemIdsByClassifyId", new Object[]{classifyId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by classifyId)  : " + classifyId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getItemIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getItemIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countItemIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getItemIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getItemIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

