/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.gene.business.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.gene.business.model.ItemLocusRelation;
import com.ptteng.gene.business.service.ItemLocusRelationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ItemLocusRelationServiceImpl
extends BaseDaoServiceImpl
implements ItemLocusRelationService {
    private static final Log log = LogFactory.getLog(ItemLocusRelationServiceImpl.class);

    public Long insert(ItemLocusRelation itemLocusRelation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + itemLocusRelation));
        if (itemLocusRelation == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        itemLocusRelation.setCreateAt(Long.valueOf(currentTimeMillis));
        itemLocusRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)itemLocusRelation);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + itemLocusRelation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ItemLocusRelation> insertList(List<ItemLocusRelation> itemLocusRelationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (itemLocusRelationList == null ? "null" : Integer.valueOf(itemLocusRelationList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(itemLocusRelationList)) {
            return new ArrayList<ItemLocusRelation>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ItemLocusRelation itemLocusRelation : itemLocusRelationList) {
            itemLocusRelation.setCreateAt(Long.valueOf(currentTimeMillis));
            itemLocusRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(itemLocusRelationList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + itemLocusRelationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ItemLocusRelation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ItemLocusRelation itemLocusRelation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (itemLocusRelation == null ? "null" : itemLocusRelation.getId())));
        boolean result = false;
        if (itemLocusRelation == null) {
            return true;
        }
        itemLocusRelation.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)itemLocusRelation);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + itemLocusRelation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + itemLocusRelation));
        }
        return result;
    }

    public boolean updateList(List<ItemLocusRelation> itemLocusRelationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (itemLocusRelationList == null ? "null" : Integer.valueOf(itemLocusRelationList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(itemLocusRelationList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ItemLocusRelation itemLocusRelation : itemLocusRelationList) {
            itemLocusRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(itemLocusRelationList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + itemLocusRelationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + itemLocusRelationList.size()));
        return result;
    }

    public ItemLocusRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ItemLocusRelation itemLocusRelation = null;
        if (id == null) {
            return itemLocusRelation;
        }
        try {
            itemLocusRelation = (ItemLocusRelation)this.dao.get(ItemLocusRelation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return itemLocusRelation;
    }

    public List<ItemLocusRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List itemLocusRelation = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ItemLocusRelation>();
        }
        try {
            itemLocusRelation = this.dao.getList(ItemLocusRelation.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (itemLocusRelation == null ? "null" : Integer.valueOf(itemLocusRelation.size()))));
        return itemLocusRelation;
    }

    public List<Object> getLocusNamesByItemId(Long itemId) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get  itemId : " + (itemId == null ? "null" : itemId)));
        List list = null;
        try {
            list = this.dao.getIdList("getLocusNamesByItemId", new Object[]{itemId}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + itemId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (list == null ? "null" : Integer.valueOf(list.size()))));
        return list;
    }

    public List<Long> getItemLocusRelationIdsByItemIdAndLocusName(Long itemId, String locusName, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by itemId,locusName,start,limit  : " + itemId + " , " + locusName + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getItemLocusRelationIdsByItemIdAndLocusName", new Object[]{itemId, locusName}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by itemId,locusName,start,limit)  : " + itemId + " , " + locusName + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countItemLocusRelationIdsByItemIdAndLocusName(Long itemId, String locusName) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by itemId,locusName  : " + itemId + " , " + locusName));
        }
        Integer count = null;
        try {
            count = this.dao.count("getItemLocusRelationIdsByItemIdAndLocusName", new Object[]{itemId, locusName});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by itemId,locusName)  : " + itemId + " , " + locusName));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getItemLocusRelationIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getItemLocusRelationIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countItemLocusRelationIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getItemLocusRelationIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getItemLocusRelationIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

