/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.gene.business.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.gene.business.model.Classify;
import com.ptteng.gene.business.service.ClassifyService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassifyServiceImpl
extends BaseDaoServiceImpl
implements ClassifyService {
    private static final Log log = LogFactory.getLog(ClassifyServiceImpl.class);

    public Long insert(Classify classify) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + classify));
        if (classify == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        classify.setCreateAt(Long.valueOf(currentTimeMillis));
        classify.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)classify);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + classify));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Classify> insertList(List<Classify> classifyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (classifyList == null ? "null" : Integer.valueOf(classifyList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(classifyList)) {
            return new ArrayList<Classify>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Classify classify : classifyList) {
            classify.setCreateAt(Long.valueOf(currentTimeMillis));
            classify.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(classifyList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + classifyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Classify.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Classify classify) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (classify == null ? "null" : classify.getId())));
        boolean result = false;
        if (classify == null) {
            return true;
        }
        classify.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)classify);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + classify));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + classify));
        }
        return result;
    }

    public boolean updateList(List<Classify> classifyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (classifyList == null ? "null" : Integer.valueOf(classifyList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(classifyList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Classify classify : classifyList) {
            classify.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(classifyList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + classifyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + classifyList.size()));
        return result;
    }

    public Classify getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Classify classify = null;
        if (id == null) {
            return classify;
        }
        try {
            classify = (Classify)this.dao.get(Classify.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return classify;
    }

    public List<Classify> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List classify = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Classify>();
        }
        try {
            classify = this.dao.getList(Classify.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (classify == null ? "null" : Integer.valueOf(classify.size()))));
        return classify;
    }

    public List<Long> getClassifyIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by name,start,limit  : " + name + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassifyIdsByName", new Object[]{name}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by name,start,limit)  : " + name + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countClassifyIdsByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by name  : " + name));
        }
        Integer count = null;
        try {
            count = this.dao.count("getClassifyIdsByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by name)  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getClassifyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassifyIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countClassifyIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getClassifyIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getClassifyIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

