/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.gene.business.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.gene.business.model.Box;
import com.ptteng.gene.business.service.BoxService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BoxServiceImpl
extends BaseDaoServiceImpl
implements BoxService {
    private static final Log log = LogFactory.getLog(BoxServiceImpl.class);

    public Long insert(Box box) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + box));
        if (box == null) {
            return null;
        }
        log.info((Object)"____________________________");
        log.info((Object)box.toString());
        long currentTimeMillis = System.currentTimeMillis();
        box.setCreateAt(Long.valueOf(currentTimeMillis));
        box.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)box);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + box));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Box> insertList(List<Box> boxList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (boxList == null ? "null" : Integer.valueOf(boxList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(boxList)) {
            return new ArrayList<Box>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Box box : boxList) {
            box.setCreateAt(Long.valueOf(currentTimeMillis));
            box.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(boxList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + boxList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Box.class, (Serializable)id);
        }
        catch (Exception e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Box box) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (box == null ? "null" : box.getId())));
        boolean result = false;
        if (box == null) {
            return true;
        }
        box.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)box);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + box));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + box));
        }
        return result;
    }

    public boolean updateList(List<Box> boxList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (boxList == null ? "null" : Integer.valueOf(boxList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(boxList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Box box : boxList) {
            box.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(boxList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + boxList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + boxList.size()));
        return result;
    }

    public Box getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Box box = null;
        if (id == null) {
            return box;
        }
        try {
            box = (Box)this.dao.get(Box.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return box;
    }

    public List<Box> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List box = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Box>();
        }
        try {
            box = this.dao.getList(Box.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (box == null ? "null" : Integer.valueOf(box.size()))));
        return box;
    }

    public List<Long> getBoxIdsBySerial(String serial, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by serial,start,limit  : " + serial + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBoxIdsBySerial", new Object[]{serial}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by serial,start,limit)  : " + serial + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getBoxIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBoxIdsByStatus", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBoxIdsBySerial(String serial) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by serial  : " + serial));
        }
        Integer count = null;
        try {
            count = this.dao.count("getBoxIdsBySerial", new Object[]{serial});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by serial)  : " + serial));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countBoxIdsByStatus(Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status  : " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getBoxIdsByStatus", new Object[]{status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status)  : " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getBoxIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBoxIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBoxIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getBoxIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getBoxIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

