/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.gene.business.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final Log log = LogFactory.getLog(ExcelUtil.class);

    public static Map<String, String> doUploadXls(MultipartFile file) throws Exception {
        HSSFWorkbook wb;
        HashMap<String, String> result = new HashMap<String, String>();
        String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."));
        log.info((Object)("file suffix is: " + suffix));
        InputStream fileIn = file.getInputStream();
        if (".xls".equals(suffix)) {
            wb = new HSSFWorkbook(fileIn);
        } else if (".xlsx".equals(suffix)) {
            wb = new XSSFWorkbook(fileIn);
        } else {
            log.error((Object)"\u6587\u4ef6\u7c7b\u578b\u9519\u8bef!");
            return result;
        }
        Sheet sheet = wb.getSheetAt(0);
        log.info((Object)("max row is: " + sheet.getLastRowNum()));
        for (int rowNum = 1; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            Row row = sheet.getRow(rowNum);
            int nameCol = 0;
            int typeCol = 1;
            Cell cellName = row.getCell(nameCol, Row.CREATE_NULL_AS_BLANK);
            Cell cellType = row.getCell(typeCol, Row.CREATE_NULL_AS_BLANK);
            result.put(ExcelUtil.cell2String(cellName), ExcelUtil.cell2String(cellType));
        }
        return result;
    }

    public static Map<String, String> readXls(String path) throws Exception {
        FileInputStream fileIn = new FileInputStream(path);
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook((InputStream)fileIn);
        HashMap<String, String> result = new HashMap<String, String>();
        HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(0);
        log.info((Object)("max row is: " + hssfSheet.getLastRowNum()));
        for (int rowNum = 1; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
            HSSFRow hssfRow = hssfSheet.getRow(rowNum);
            int nameCol = 0;
            int typeCol = 1;
            HSSFCell cellName = hssfRow.getCell(nameCol, Row.CREATE_NULL_AS_BLANK);
            HSSFCell cellType = hssfRow.getCell(typeCol, Row.CREATE_NULL_AS_BLANK);
            result.put(ExcelUtil.cell2String((Cell)cellName), ExcelUtil.cell2String((Cell)cellType));
        }
        return result;
    }

    private static String cell2String(Cell cell) {
        if (cell.getCellType() == 3) {
            return "";
        }
        return cell.toString();
    }
}

