-- ----------------------------
-- Table structure for `orders`
-- ----------------------------
-- DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `uid` bigint(20) NOT NULL   COMMENT '用户id',
    `pay_no` varchar(100) NOT NULL   COMMENT '第三方流水号',
    `orders_no` varchar(30) NOT NULL   COMMENT '交易流水号',
    `product` varchar(100) NOT NULL   COMMENT '商品名称',
    `amount` varchar(30) NOT NULL   COMMENT '订单金额',
    `type` int(2) NOT NULL   COMMENT '交易类型(0:方案支付,10=微官网定制支付)',
    `status` int(2) NOT NULL   COMMENT '交易状态(1：已完成；2：待付款 3: 已取消 4:已退款 5:已失效)',
    `way` int(2) NOT NULL   COMMENT '第三方平台种类 1 微信 2 支付宝',
    `pay_at` bigint(20) NOT NULL   COMMENT '支付时间',
    `order_at` bigint(20) NOT NULL   COMMENT '订单生成时间',
    `end_at` bigint(20) NOT NULL   COMMENT '生成订单失效时间',
    `goods_id` bigint(20) NOT NULL   COMMENT '商品id',
    `order_type` int(11) NOT NULL   COMMENT '订单类型 1=支付 2=续费',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;





