/**
 * 使用URLConnection的�?�讯�?
 *
 * @author xiezz
 * @version 1.1.2
 */
package com.ptteng.fans.common.util.cft;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.net.ssl.*;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class HttpsPostRequest extends IRequestService {
    private static final Log log = LogFactory
            .getLog(HttpsPostRequest.class);
    private final static int BUFFER_SIZE = 2048;

    public Object sendPost(String url, Map<String, String> params) throws KeyManagementException, NoSuchAlgorithmException, IOException {

        log.info(" sendPost url =  "+url+" params = "+params);

        //ƴװ����MapΪString����URLEncode
        StringBuffer paramstr = new StringBuffer();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            paramstr.append(entry.getKey())
                    .append("=")
                    .append(URLEncoder.encode(entry.getValue(), "UTF-8"))
                    .append("&");
        }
        String param = paramstr.toString();
        log.info(" param = "+param);
        return this.sendPost(url, param.substring(0, param.length() - 1));
    }

    public Object sendPost(String url, String params) throws IOException, KeyManagementException, NoSuchAlgorithmException {

        log.info("  sendPost url ="+url+" params = "+params);
        URL connurl = new URL(url);
        HttpURLConnection conn = null;
        Object ret = null;
        OutputStream outStream = null;
        InputStream inStream = null;

        try {
            conn = (HttpURLConnection) connurl.openConnection();

            //���Ի�������SSL֤����֤
            //����������Ϊfalse
            if (false && connurl.getProtocol().equals("https")) {
                ignoreSSLVerify((HttpsURLConnection) conn);
            }

            conn.setRequestMethod("POST");
            conn.setDoOutput(true);

            outStream = conn.getOutputStream();
            outStream.write(params.getBytes("UTF-8"));
            outStream.flush();
            log.info("  1212   ");
            inStream = conn.getInputStream();
            byte[] bin = readInputStream(inStream);

            if ("application/octet-stream".equals(conn.getContentType())) {
                ret = bin;
            } else {
                ret = new String(bin, "UTF-8");
            }
        } finally {
            if (inStream != null) inStream.close();
            if (outStream != null) outStream.close();
            if (conn != null) conn.disconnect();
        }
        return ret;
    }

    private static byte[] readInputStream(InputStream inStream) throws IOException {

        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] data = null;
        byte[] buffer = new byte[BUFFER_SIZE];
        int len = 0;
        try {
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            data = outStream.toByteArray();
        } finally {
            if (outStream != null)
                outStream.close();
        }
        return data;
    }

    private static void ignoreSSLVerify(HttpsURLConnection conn) throws NoSuchAlgorithmException, KeyManagementException {

        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager() {
            public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(
                    java.security.cert.X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(
                    java.security.cert.X509Certificate[] certs, String authType) {
            }
        }};

        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new java.security.SecureRandom());

        conn.setSSLSocketFactory(sc.getSocketFactory());

        conn.setHostnameVerifier(new HostnameVerifier() {
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }
}
