package com.ptteng.fans.common.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.fans.common.model.UserAccountRelation;
import com.ptteng.fans.common.service.UserAccountRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserAccountRelationServiceImpl extends BaseDaoServiceImpl implements UserAccountRelationService {

 

	private static final Log log = LogFactory.getLog(UserAccountRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserAccountRelation userAccountRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userAccountRelation);

		if (userAccountRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userAccountRelation.setCreateAt(currentTimeMillis);
		userAccountRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userAccountRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userAccountRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserAccountRelation> insertList(List<UserAccountRelation> userAccountRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userAccountRelationList == null ? "null" : userAccountRelationList.size()));
      
		List<UserAccountRelation> resultList = null;

		if (CollectionUtils.isEmpty(userAccountRelationList)) {
			return new ArrayList<UserAccountRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserAccountRelation userAccountRelation : userAccountRelationList) {
			userAccountRelation.setCreateAt(currentTimeMillis);
			userAccountRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserAccountRelation>) dao.batchSave(userAccountRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userAccountRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserAccountRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserAccountRelation userAccountRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userAccountRelation == null ? "null" : userAccountRelation.getId()));

		boolean result = false;

		if (userAccountRelation == null) {
			return true;
		}

		userAccountRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userAccountRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userAccountRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userAccountRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserAccountRelation> userAccountRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userAccountRelationList == null ? "null" : userAccountRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userAccountRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserAccountRelation userAccountRelation : userAccountRelationList) {
			userAccountRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userAccountRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userAccountRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userAccountRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserAccountRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserAccountRelation userAccountRelation = null;

		if (id == null) {
			return userAccountRelation;
		}

		try {
			userAccountRelation = (UserAccountRelation) dao.get(UserAccountRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userAccountRelation;		
		}	
		  
    	   
		@Override
		public List<UserAccountRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserAccountRelation> userAccountRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserAccountRelation>();
		}

		try {
			userAccountRelation = (List<UserAccountRelation>) dao.getList(UserAccountRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userAccountRelation == null ? "null" : userAccountRelation.size()));
    
		return userAccountRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getUserAccountRelationIdByAccount(String account)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by account  : " + account );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getUserAccountRelationIdByAccount", new Object[] {account });
   } catch (DaoException e) {
			log.error(" get id wrong by account  : " + account );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getUserAccountRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserAccountRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserAccountRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserAccountRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserAccountRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getUserAccountRelationIdByAccountAndType(String account,Integer type)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by account,type  : " + account+" , "+type );
		}
		Long id = null;

		// TODO 参数检查!

		try {


			id = (Long) dao.getMapping("getUserAccountRelationIdByAccountAndType", new Object[] {account,type });
		} catch (DaoException e) {
			log.error(" get id wrong by account,type  : " + account+" , "+type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}




}

