package com.ptteng.fans.common.service.impl;

import com.ptteng.fans.common.service.PayOrderService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.annotation.Resource;
import java.util.Map;

public class PayInterfaceImpl  implements PayOrderService {
	private static final Log log = LogFactory.getLog(PayInterfaceImpl.class);

	@Resource(name = "processServiceConfig")
	private Map<String, PayOrderService> processServiceConfig;



	@Override
	public String pay(String userid, String merchantOrderId,
			String merchantOrderTime, String merchantOrderName,
			String merchantOrderAmt, String merchantOrderDesc, String frontUrl,
			String backUrl,String type)  {

		try {
			PayOrderService  payOrderService = processServiceConfig.get(type);
			return payOrderService.pay(userid, merchantOrderId, merchantOrderTime, merchantOrderName, merchantOrderAmt, merchantOrderDesc, frontUrl, backUrl, type);
		} catch (Exception e) {
			log.error("param 'type' error :" +e.getMessage());
			return null;
		}
	}

	@Override
	public String pyPay(String order_no, String to_bank_no, String to_acct_no, String to_acct_name, String acct_type, String trans_amt,
						String trans_usage, String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.pyPay(order_no, to_bank_no, to_acct_no, to_acct_name, acct_type, trans_amt, trans_usage, type);

	}

	@Override
	public String payTest(String code,String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);

		return payOrderService.payTest(code,type);
	}
	@Override
	public String notice(String xmlString,String type) {

		try {
			PayOrderService  payOrderService = processServiceConfig.get(type);
			return payOrderService.notice(xmlString, type);
		} catch (Exception e) {
			log.error("param 'type' error :" +e.getMessage());
			return null;
		}
	}

	@Override
	public boolean ylnotice(Map<String, String> reqData, String encoding,String type)  {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.ylnotice(reqData,encoding,type);
	}

	@Override
	public String check(String merchantOrderId, String merchantOrderTime,String type)
			 {

		try {
			PayOrderService  payOrderService = processServiceConfig.get(type);
			return payOrderService.check(merchantOrderId,merchantOrderTime, type);
		} catch (Exception e) {
			log.error("param 'type' error :" +e.getMessage());
			return null;
		}

	}

	@Override
	public String checkPayment(String merchantOrderId, String merchantOrderTime, String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.checkPayment(merchantOrderId,merchantOrderTime,type);
	}

	@Override
	public String getParam(String key,String type)  {

		try {
			PayOrderService  payOrderService = processServiceConfig.get(type);
			return payOrderService.getParam(key, type);
		} catch (Exception e) {
			log.error("param 'type' error :" +e.getMessage());
			return null;
		}
	}

	@Override
	public String epAuthSyncWithSms(String trac_no, String acct_type, String bank_no, String card_no, String user_name, String cert_no, String card_phone, String expireDate, String cvn,String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.epAuthSyncWithSms(trac_no,acct_type,bank_no,card_no,user_name,cert_no,card_phone,expireDate,cvn
		,type);
	}

	@Override
	public String epAuthCheckSms(String trac_no, String sms_code,String type) {

		PayOrderService  payOrderService = processServiceConfig.get(type);

		return payOrderService.epAuthCheckSms(trac_no,sms_code,type);
	}

	@Override
	public String epAuthQuery(String trac_no, String type) {
		PayOrderService  payOrderService = processServiceConfig.get(type);
		return payOrderService.epAuthQuery(trac_no,type);
	}


}
