package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.fans.common.model.Brand;
import com.ptteng.fans.common.service.BrandService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class BrandServiceImpl extends BaseDaoServiceImpl implements BrandService {


  private static final Log log = LogFactory.getLog(BrandServiceImpl.class);


  @Override
  public Long insert(Brand brand) throws ServiceException, ServiceDaoException {

    log.info(" insert data : " + brand);

    if (brand == null) {
      return null;
    }

    long currentTimeMillis = System.currentTimeMillis();
    brand.setCreateAt(currentTimeMillis);
    brand.setUpdateAt(currentTimeMillis);

    Long result = null;
    try {
      result = (Long) dao.save(brand);
    } catch (DaoException e) {
      log.error(" insert wrong : " + brand);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }

    log.info(" insert data success : " + result);

    return result;
  }


  @Override
  public List<Brand> insertList(List<Brand> brandList)
      throws ServiceException, ServiceDaoException {

    log.info(" insert lists : " + (brandList == null ? "null" : brandList.size()));

    List<Brand> resultList = null;

    if (CollectionUtils.isEmpty(brandList)) {
      return new ArrayList<Brand>();
    }

    long currentTimeMillis = System.currentTimeMillis();
    for (Brand brand : brandList) {
      brand.setCreateAt(currentTimeMillis);
      brand.setUpdateAt(currentTimeMillis);
    }

    try {
      resultList = (List<Brand>) dao.batchSave(brandList);
    } catch (DaoException e) {
      log.error(" insert list wrong : " + brandList);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }

    log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

    return resultList;


  }


  @Override
  public boolean delete(Long id) throws ServiceException, ServiceDaoException {

    log.info(" delete data : " + id);

    boolean result = false;

    if (id == null) {
      return true;
    }

    try {
      result = dao.delete(Brand.class, id);
    } catch (DaoException e) {
      log.error(" delete wrong : " + id);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }

    log.info(" delete data success : " + id);

    return result;

  }


  @Override
  public boolean update(Brand brand) throws ServiceException, ServiceDaoException {

    log.info(" update data : " + (brand == null ? "null" : brand.getId()));

    boolean result = false;

    if (brand == null) {
      return true;
    }

    brand.setUpdateAt(System.currentTimeMillis());

    try {
      result = dao.update(brand);
    } catch (DaoException e) {
      log.error(" update wrong : " + brand);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }
    if (log.isInfoEnabled()) {
      log.info(" update data success : " + brand);
    }
    return result;
  }


  @Override
  public boolean updateList(List<Brand> brandList) throws ServiceException, ServiceDaoException {

    log.info(" update lists : " + (brandList == null ? "null" : brandList.size()));

    boolean result = false;

    if (CollectionUtils.isEmpty(brandList)) {
      return true;
    }

    long currentTimeMillis = System.currentTimeMillis();
    for (Brand brand : brandList) {
      brand.setUpdateAt(currentTimeMillis);
    }

    try {
      result = dao.batchUpdate(brandList);
    } catch (DaoException e) {
      log.error(" update list wrong : " + brandList);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }

    log.info(" update lists success : " + brandList.size());

    return result;
  }


  @Override
  public Brand getObjectById(Long id) throws ServiceException, ServiceDaoException {

    log.info(" get data : " + id);

    Brand brand = null;

    if (id == null) {
      return brand;
    }

    try {
      brand = (Brand) dao.get(Brand.class, id);
    } catch (DaoException e) {
      log.error(" get wrong : " + id);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }

    log.info(" get data success : " + id);

    return brand;
  }


  @Override
  public List<Brand> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

    log.info(" get lists : " + (ids == null ? "null" : ids));

    List<Brand> brand = null;

    if (CollectionUtils.isEmpty(ids)) {
      return new ArrayList<Brand>();
    }

    try {
      brand = (List<Brand>) dao.getList(Brand.class, ids);
    } catch (DaoException e) {
      log.error(" get wrong : " + ids);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }

    log.info(" get data success : " + (brand == null ? "null" : brand.size()));

    return brand;
  }


  @Override
  public List<Long> getBrandIds(Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {

    log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
    List<Long> idList = null;

    if (start == null) {
      start = 0;
    }

    if (limit == null) {
      limit = Integer.MAX_VALUE;
    }

    try {
      idList = dao.getIdList("getBrandIdsAll", new Object[]{}, start, limit, false);
    } catch (DaoException e) {
      log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }
    if (log.isInfoEnabled()) {
      log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
    }
    return idList;
  }


  @Override
  public Integer countBrandIds() throws ServiceException,
      ServiceDaoException {
    Integer count = 0;
    try {
      count = dao.count("getBrandIdsAll", new Object[]{});
    } catch (DaoException e) {
      log.error(" count by getBrandIds ");
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }
    if (log.isInfoEnabled()) {
      log.info(" count  : " + count);
    }
    return count;
  }

}

