-- ----------------------------
-- Table structure for `base_classify`
-- ----------------------------
DROP TABLE IF EXISTS `base_classify`;
CREATE TABLE `base_classify` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '主键,自增长ID',
    `level` int(3) NOT NULL   COMMENT '分级',
    `intro` varchar(225)    COMMENT '介绍',
    `cover_url` varchar(225)    COMMENT '背景图',
    `name` varchar(50) NOT NULL   COMMENT '名称',
    `sort` bigint(20)    COMMENT '排序',
    `pid` bigint(20) NOT NULL   COMMENT '二级分类id',
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',
    `update_by` bigint(20) NOT NULL   COMMENT '修改人',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    `status` int(5)    COMMENT '上下架',
    `merchant_id` bigint(20)    COMMENT '商户ID',
    `type` int(11)    COMMENT '应用类型',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;




-- ----------------------------
-- Table structure for `orders`
-- ----------------------------
DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `uid` bigint(20) NOT NULL   COMMENT '用户id',
    `pay_no` varchar(100) NOT NULL   COMMENT '第三方流水号',
    `orders_no` varchar(30) NOT NULL   COMMENT '交易流水号',
    `product` varchar(100) NOT NULL   COMMENT '商品名称',
    `amount` varchar(30) NOT NULL   COMMENT '订单金额',
    `type` int(2) NOT NULL   COMMENT '交易类型(0:方案支付,10=微官网定制支付)',
    `status` int(2) NOT NULL   COMMENT '交易状态(1：已完成；2：待付款 3: 已取消 4:已退款 5:已失效)',
    `way` int(2) NOT NULL   COMMENT '第三方平台种类 1 微信 2 支付宝',
    `pay_at` bigint(20) NOT NULL   COMMENT '支付时间',
    `order_at` bigint(20) NOT NULL   COMMENT '订单生成时间',
    `end_at` bigint(20) NOT NULL   COMMENT '生成订单失效时间',
    `goods_id` bigint(20) NOT NULL   COMMENT '商品id',
    `order_type` int(11) NOT NULL   COMMENT '订单类型 1=支付 2=续费',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;




-- ----------------------------
-- Table structure for `contents`
-- ----------------------------
DROP TABLE IF EXISTS `contents`;
CREATE TABLE `contents` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT 'id',
    `img` varchar(255)    COMMENT '图片链接',
    `title` text    COMMENT '标题',
    `sort` int(3)    COMMENT '排序',
    `author` varchar(50)    COMMENT '作者',
    `content` longtext    COMMENT '内容',
    `summary` varchar(200)    COMMENT '摘要',
    `url` varchar(255)    COMMENT '链接(文章来源)',
    `status` tinyint(4) NOT NULL   COMMENT '上下架  0 下架 1上架',
    `type` int(11)    COMMENT '应用类型',
    `merchant_id` bigint(20)    COMMENT '商户ID',
    `create_by` bigint(20) NOT NULL   COMMENT '创建人ID',
    `update_by` bigint(20) NOT NULL   COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;




-- ----------------------------
-- Table structure for `classify_contents_relation`
-- ----------------------------
DROP TABLE IF EXISTS `classify_contents_relation`;
CREATE TABLE `classify_contents_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '主键,自增长ID',  
    `contents_id` bigint(20) NOT NULL   COMMENT '内容ID',  
    `classify_id` bigint(20) NOT NULL   COMMENT '分类ID',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建者',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新者',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4;





