package com.ptteng.fans.common.util;


import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.fans.common.model.BaseClassify;
import com.qding.common.util.DataUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.ui.ModelMap;


/**
* 每个实体类列表查询对应一个ids查询方法，除非特别情况，不允许编写第二个ids查询方法
*
**/
public class BaseClassifyUtil {

public static final Integer SORT_UPDATE_DESC = 1;

/**
* 传入参数获取对象ids
*
**/
public static Map<String,Object> getBaseClassifyIds(Integer sort,Boolean count) {
      Map<String, Object> params = new HashMap<>();
      Set<String> tables = new HashSet<>();
  tables.add("base_classify");


  if(SORT_UPDATE_DESC.equals(sort)){
  params.put("@order"," update_at desc");
  }

  if (count) {
  params.put("@query", " count(id) ");
  } else {
  params.put("@query", " id ");
  }

  params.put("@table", SQLUtil.convertTable(tables));

  return params;
  }

  /**
  * 对传入实体对象的属性做非空校验
  */
  public static boolean checkBaseClassify(BaseClassify baseClassify,
  ModelMap model) {

  if (DataUtils.isNullOrEmpty(baseClassify)) {
  model.addAttribute("code", -1000);
  return false;
  }

  return true;
  }

  }
