package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.fans.common.model.Word;
import com.ptteng.fans.common.service.WordService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class WordServiceImpl extends BaseDaoServiceImpl implements WordService {

 

	private static final Log log = LogFactory.getLog(WordServiceImpl.class);



		   
		@Override
		public Long insert(Word word)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + word);

		if (word == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		word.setCreateAt(currentTimeMillis);
		word.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(word);
		} catch (DaoException e) {
			log.error(" insert wrong : " + word);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Word> insertList(List<Word> wordList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (wordList == null ? "null" : wordList.size()));
      
		List<Word> resultList = null;

		if (CollectionUtils.isEmpty(wordList)) {
			return new ArrayList<Word>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Word word : wordList) {
			word.setCreateAt(currentTimeMillis);
			word.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Word>) dao.batchSave(wordList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + wordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Word.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Word word)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (word == null ? "null" : word.getId()));

		boolean result = false;

		if (word == null) {
			return true;
		}

		word.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(word);
		} catch (DaoException e) {
			log.error(" update wrong : " + word);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + word);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Word> wordList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (wordList == null ? "null" : wordList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(wordList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Word word : wordList) {
			word.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(wordList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + wordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + wordList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Word getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Word word = null;

		if (id == null) {
			return word;
		}

		try {
			word = (Word) dao.get(Word.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return word;		
		}	
		  
    	   
		@Override
		public List<Word> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Word> word = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Word>();
		}

		try {
			word = (List<Word>) dao.getList(Word.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (word == null ? "null" : word.size()));
    
		return word;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getWordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getWordIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countWordIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getWordIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getWordIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

