package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.fans.common.model.UserMessageRelation;
import com.ptteng.fans.common.service.UserMessageRelationService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserMessageRelationServiceImpl extends BaseDaoServiceImpl implements UserMessageRelationService {


    private static final Log log = LogFactory.getLog(UserMessageRelationServiceImpl.class);


    @Override
    public Long insert(UserMessageRelation userMessageRelation) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + userMessageRelation);

        if (userMessageRelation == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        userMessageRelation.setCreateAt(currentTimeMillis);
        userMessageRelation.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(userMessageRelation);
        } catch (DaoException e) {
            log.error(" insert wrong : " + userMessageRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<UserMessageRelation> insertList(List<UserMessageRelation> userMessageRelationList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (userMessageRelationList == null ? "null" : userMessageRelationList.size()));

        List<UserMessageRelation> resultList = null;

        if (CollectionUtils.isEmpty(userMessageRelationList)) {
            return new ArrayList<UserMessageRelation>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserMessageRelation userMessageRelation : userMessageRelationList) {
            userMessageRelation.setCreateAt(currentTimeMillis);
            userMessageRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<UserMessageRelation>) dao.batchSave(userMessageRelationList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + userMessageRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(UserMessageRelation.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(UserMessageRelation userMessageRelation) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (userMessageRelation == null ? "null" : userMessageRelation.getId()));

        boolean result = false;

        if (userMessageRelation == null) {
            return true;
        }

        userMessageRelation.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(userMessageRelation);
        } catch (DaoException e) {
            log.error(" update wrong : " + userMessageRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + userMessageRelation);
        }
        return result;
    }


    @Override
    public boolean updateList(List<UserMessageRelation> userMessageRelationList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (userMessageRelationList == null ? "null" : userMessageRelationList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(userMessageRelationList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserMessageRelation userMessageRelation : userMessageRelationList) {
            userMessageRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(userMessageRelationList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + userMessageRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + userMessageRelationList.size());

        return result;
    }


    @Override
    public UserMessageRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        UserMessageRelation userMessageRelation = null;

        if (id == null) {
            return userMessageRelation;
        }

        try {
            userMessageRelation = (UserMessageRelation) dao.get(UserMessageRelation.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return userMessageRelation;
    }


    @Override
    public List<UserMessageRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<UserMessageRelation> userMessageRelation = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserMessageRelation>();
        }

        try {
            userMessageRelation = (List<UserMessageRelation>) dao.getList(UserMessageRelation.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (userMessageRelation == null ? "null" : userMessageRelation.size()));

        return userMessageRelation;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserMessageRelationIdsByNameAndNick(Long targetId, Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by name,nick,start,limit  : " + targetId + " , " + userId + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserMessageRelationIdsByNameAndNick", new Object[]{targetId, userId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by name,nick,start,limit)  : " + targetId + " , " + userId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserMessageRelationIdsByNick(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by nick,start,limit  : " + userId + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserMessageRelationIdsByNick", new Object[]{userId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by nick,start,limit)  : " + userId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserMessageRelationIdsByName(Long targetId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by name,start,limit  : " + targetId + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserMessageRelationIdsByName", new Object[]{targetId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by name,start,limit)  : " + targetId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserMessageRelationIdsByNameAndNick(Long targetId, Long userId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by name,nick  : " + targetId + " , " + userId);
        }
        Integer count = null;


        try {

            count = dao.count("getUserMessageRelationIdsByNameAndNick", new Object[]{targetId, userId});


        } catch (DaoException e) {
            log.error(" count ids  wrong by name,nick)  : " + targetId + " , " + userId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserMessageRelationIdsByNick(Long userId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by nick  : " + userId);
        }
        Integer count = null;


        try {

            count = dao.count("getUserMessageRelationIdsByNick", new Object[]{userId});


        } catch (DaoException e) {
            log.error(" count ids  wrong by nick)  : " + userId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserMessageRelationIdsByName(Long targetId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by name  : " + targetId);
        }
        Integer count = null;


        try {

            count = dao.count("getUserMessageRelationIdsByName", new Object[]{targetId});


        } catch (DaoException e) {
            log.error(" count ids  wrong by name)  : " + targetId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getUserMessageRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserMessageRelationIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countUserMessageRelationIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getUserMessageRelationIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getUserMessageRelationIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

