package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.fans.common.model.ProfitSharing;
import com.ptteng.fans.common.service.ProfitSharingService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ProfitSharingServiceImpl extends BaseDaoServiceImpl implements ProfitSharingService {

 

	private static final Log log = LogFactory.getLog(ProfitSharingServiceImpl.class);



		   
		@Override
		public Long insert(ProfitSharing profitSharing)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + profitSharing);

		if (profitSharing == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		profitSharing.setCreateAt(currentTimeMillis);
		profitSharing.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(profitSharing);
		} catch (DaoException e) {
			log.error(" insert wrong : " + profitSharing);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<ProfitSharing> insertList(List<ProfitSharing> profitSharingList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (profitSharingList == null ? "null" : profitSharingList.size()));
      
		List<ProfitSharing> resultList = null;

		if (CollectionUtils.isEmpty(profitSharingList)) {
			return new ArrayList<ProfitSharing>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ProfitSharing profitSharing : profitSharingList) {
			profitSharing.setCreateAt(currentTimeMillis);
			profitSharing.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<ProfitSharing>) dao.batchSave(profitSharingList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + profitSharingList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(ProfitSharing.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(ProfitSharing profitSharing)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (profitSharing == null ? "null" : profitSharing.getId()));

		boolean result = false;

		if (profitSharing == null) {
			return true;
		}

		profitSharing.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(profitSharing);
		} catch (DaoException e) {
			log.error(" update wrong : " + profitSharing);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + profitSharing);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<ProfitSharing> profitSharingList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (profitSharingList == null ? "null" : profitSharingList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(profitSharingList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ProfitSharing profitSharing : profitSharingList) {
			profitSharing.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(profitSharingList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + profitSharingList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + profitSharingList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public ProfitSharing getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		ProfitSharing profitSharing = null;

		if (id == null) {
			return profitSharing;
		}

		try {
			profitSharing = (ProfitSharing) dao.get(ProfitSharing.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return profitSharing;		
		}	
		  
    	   
		@Override
		public List<ProfitSharing> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<ProfitSharing> profitSharing = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<ProfitSharing>();
		}

		try {
			profitSharing = (List<ProfitSharing>) dao.getList(ProfitSharing.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (profitSharing == null ? "null" : profitSharing.size()));
    
		return profitSharing;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProfitSharingIdsByOrdersIdAndStatus(Long ordersId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by ordersId,status,start,limit  : " + ordersId+" , "+status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getProfitSharingIdsByOrdersIdAndStatus", new Object[] { ordersId,status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by ordersId,status,start,limit)  : " + ordersId+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProfitSharingIdsByOrdersIdAndStatusAndAccount(Long ordersId,Integer status,String account,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by ordersId,status,account,start,limit  : " + ordersId+" , "+status+" , "+account+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getProfitSharingIdsByOrdersIdAndStatusAndAccount", new Object[] { ordersId,status,account},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by ordersId,status,account,start,limit)  : " + ordersId+" , "+status+" , "+account+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProfitSharingIdsByOrdersId(Long ordersId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by ordersId,start,limit  : " + ordersId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getProfitSharingIdsByOrdersId", new Object[] { ordersId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by ordersId,start,limit)  : " + ordersId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProfitSharingIdsByOrdersIdAndStatus(Long ordersId,Integer status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by ordersId,status  : " + ordersId+" , "+status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getProfitSharingIdsByOrdersIdAndStatus", new Object[] { ordersId,status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by ordersId,status)  : " + ordersId+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProfitSharingIdsByOrdersIdAndStatusAndAccount(Long ordersId,Integer status,String account)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by ordersId,status,account  : " + ordersId+" , "+status+" , "+account );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getProfitSharingIdsByOrdersIdAndStatusAndAccount", new Object[] { ordersId,status,account});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by ordersId,status,account)  : " + ordersId+" , "+status+" , "+account );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProfitSharingIdsByOrdersId(Long ordersId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by ordersId  : " + ordersId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getProfitSharingIdsByOrdersId", new Object[] { ordersId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by ordersId)  : " + ordersId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getProfitSharingIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getProfitSharingIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countProfitSharingIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getProfitSharingIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getProfitSharingIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

