package com.ptteng.fans.common.service.impl;

import com.ptteng.fans.common.model.Production;
import com.ptteng.fans.common.service.ProductionService;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;





import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ProductionServiceImpl extends BaseDaoServiceImpl implements ProductionService {



	private static final Log log = LogFactory.getLog(ProductionServiceImpl.class);




		@Override
		public Long insert(Production production)throws ServiceException, ServiceDaoException{



    log.info(" insert data : " + production);

		if (production == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		production.setCreateAt(currentTimeMillis);
		production.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(production);
		} catch (DaoException e) {
			log.error(" insert wrong : " + production);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

return result;
		}


		@Override
		public List<Production> insertList(List<Production> productionList)throws ServiceException, ServiceDaoException{



        log.info(" insert lists : " + (productionList == null ? "null" : productionList.size()));

		List<Production> resultList = null;

		if (CollectionUtils.isEmpty(productionList)) {
			return new ArrayList<Production>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Production production : productionList) {
			production.setCreateAt(currentTimeMillis);
			production.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Production>) dao.batchSave(productionList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + productionList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



		}


		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{



	    log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Production.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

		}


		@Override
		public boolean update(Production production)throws ServiceException, ServiceDaoException{



	log.info(" update data : " + (production == null ? "null" : production.getId()));

		boolean result = false;

		if (production == null) {
			return true;
		}

		production.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(production);
		} catch (DaoException e) {
			log.error(" update wrong : " + production);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + production);
       }
		return result;
		}


		@Override
		public boolean updateList(List<Production> productionList)throws ServiceException, ServiceDaoException{


		          log.info(" update lists : " + (productionList == null ? "null" : productionList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(productionList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Production production : productionList) {
			production.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(productionList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + productionList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + productionList.size());

		return result;
		}


		@Override
		public Production getObjectById(Long id)throws ServiceException, ServiceDaoException{



        log.info(" get data : " + id);

		Production production = null;

		if (id == null) {
			return production;
		}

		try {
			production = (Production) dao.get(Production.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return production;
		}


		@Override
		public List<Production> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



	    log.info(" get lists : " + (ids == null ? "null" : ids));

		List<Production> production = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Production>();
		}

		try {
			production = (List<Production>) dao.getList(Production.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (production == null ? "null" : production.size()));

		return production;
		}












	@Override
	public List<Long> getProductionIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getProductionIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


		@Override
	public Integer countProductionIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getProductionIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getProductionIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

