package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.fans.common.model.BaseClassify;
import com.ptteng.fans.common.service.BaseClassifyService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class BaseClassifyServiceImpl extends BaseDaoServiceImpl implements BaseClassifyService {

 

	private static final Log log = LogFactory.getLog(BaseClassifyServiceImpl.class);



		   
		@Override
		public Long insert(BaseClassify baseClassify)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + baseClassify);

		if (baseClassify == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		baseClassify.setCreateAt(currentTimeMillis);
		baseClassify.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(baseClassify);
		} catch (DaoException e) {
			log.error(" insert wrong : " + baseClassify);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<BaseClassify> insertList(List<BaseClassify> baseClassifyList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (baseClassifyList == null ? "null" : baseClassifyList.size()));
      
		List<BaseClassify> resultList = null;

		if (CollectionUtils.isEmpty(baseClassifyList)) {
			return new ArrayList<BaseClassify>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (BaseClassify baseClassify : baseClassifyList) {
			baseClassify.setCreateAt(currentTimeMillis);
			baseClassify.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<BaseClassify>) dao.batchSave(baseClassifyList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + baseClassifyList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(BaseClassify.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(BaseClassify baseClassify)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (baseClassify == null ? "null" : baseClassify.getId()));

		boolean result = false;

		if (baseClassify == null) {
			return true;
		}

		baseClassify.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(baseClassify);
		} catch (DaoException e) {
			log.error(" update wrong : " + baseClassify);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + baseClassify);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<BaseClassify> baseClassifyList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (baseClassifyList == null ? "null" : baseClassifyList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(baseClassifyList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (BaseClassify baseClassify : baseClassifyList) {
			baseClassify.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(baseClassifyList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + baseClassifyList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + baseClassifyList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public BaseClassify getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		BaseClassify baseClassify = null;

		if (id == null) {
			return baseClassify;
		}

		try {
			baseClassify = (BaseClassify) dao.get(BaseClassify.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return baseClassify;		
		}	
		  
    	   
		@Override
		public List<BaseClassify> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<BaseClassify> baseClassify = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<BaseClassify>();
		}

		try {
			baseClassify = (List<BaseClassify>) dao.getList(BaseClassify.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (baseClassify == null ? "null" : baseClassify.size()));
    
		return baseClassify;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getBaseClassifyIdsByTypeAndMerchantIdOrderBySort(Integer type,Long merchantId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by type,merchantId,start,limit  : " + type+" , "+merchantId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getBaseClassifyIdsByTypeAndMerchantIdOrderBySort", new Object[] { type,merchantId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by type,merchantId,start,limit)  : " + type+" , "+merchantId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getBaseClassifyIdsByType(Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by type,start,limit  : " + type+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getBaseClassifyIdsByType", new Object[] { type},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by type,start,limit)  : " + type+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getBaseClassifyIdsByMerchantId(Long merchantId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by merchantId,start,limit  : " + merchantId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getBaseClassifyIdsByMerchantId", new Object[] { merchantId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by merchantId,start,limit)  : " + merchantId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countBaseClassifyIdsByTypeAndMerchantIdOrderBySort(Integer type,Long merchantId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by type,merchantId  : " + type+" , "+merchantId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getBaseClassifyIdsByTypeAndMerchantIdOrderBySort", new Object[] { type,merchantId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by type,merchantId)  : " + type+" , "+merchantId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countBaseClassifyIdsByType(Integer type)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by type  : " + type );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getBaseClassifyIdsByType", new Object[] { type});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by type)  : " + type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countBaseClassifyIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by merchantId  : " + merchantId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getBaseClassifyIdsByMerchantId", new Object[] { merchantId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by merchantId)  : " + merchantId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getBaseClassifyIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getBaseClassifyIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countBaseClassifyIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getBaseClassifyIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getBaseClassifyIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

