package com.ptteng.fans.common.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.fans.common.model.Application;
import com.ptteng.fans.common.service.ApplicationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ApplicationServiceImpl extends BaseDaoServiceImpl implements ApplicationService {

 

	private static final Log log = LogFactory.getLog(ApplicationServiceImpl.class);



		   
		@Override
		public Long insert(Application application)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + application);

		if (application == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		application.setCreateAt(currentTimeMillis);
		application.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(application);
		} catch (DaoException e) {
			log.error(" insert wrong : " + application);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Application> insertList(List<Application> applicationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (applicationList == null ? "null" : applicationList.size()));
      
		List<Application> resultList = null;

		if (CollectionUtils.isEmpty(applicationList)) {
			return new ArrayList<Application>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Application application : applicationList) {
			application.setCreateAt(currentTimeMillis);
			application.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Application>) dao.batchSave(applicationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + applicationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Application.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Application application)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (application == null ? "null" : application.getId()));

		boolean result = false;

		if (application == null) {
			return true;
		}

		application.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(application);
		} catch (DaoException e) {
			log.error(" update wrong : " + application);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + application);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Application> applicationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (applicationList == null ? "null" : applicationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(applicationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Application application : applicationList) {
			application.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(applicationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + applicationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + applicationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Application getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Application application = null;

		if (id == null) {
			return application;
		}

		try {
			application = (Application) dao.get(Application.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return application;		
		}	
		  
    	   
		@Override
		public List<Application> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Application> application = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Application>();
		}

		try {
			application = (List<Application>) dao.getList(Application.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (application == null ? "null" : application.size()));
    
		return application;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getApplicationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getApplicationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countApplicationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getApplicationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getApplicationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

