/**
 * 无跳转，直接POST通讯方式的接�?
 *
 * @author xiezz
 * @version 1.1.2
 */
package com.ptteng.fans.common.util.cft;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;


public abstract class IPostService {
    private static final Log log = LogFactory
            .getLog(IPostService.class);

    /**
     * 通讯接口，返回报文为json格式
     *
     * @param params post待发送的包含所有参数的Map
     * @return JSON报文
     * @throws IllegalAccessException
     * @throws InstantiationException
     * @throws ClassNotFoundException
     * @throws IOException
     * @throws NoSuchAlgorithmException
     * @throws MalformedURLException
     * @throws KeyManagementException
     */
    public static String txn(String url, Map<String, String> params,String commKey,String cert) {
        log.info(" txn start  commKey = "+commKey);
        String json = null;
        try {
            IRequestService requestor = IRequestService.getInstance();
            json = (String) requestor.sendPost(url, params);
            log.info(" json = "+json);
            log.info("  Signature.verifyMAC(Signature.jsonToMap(json),commKey,cert) = "+
                    Signature.verifyMAC(Signature.jsonToMap(json),commKey,cert));
            if (!Signature.verifyMAC(Signature.jsonToMap(json),commKey,cert)) {
                log.info("  error1");
                return "-1";
            }
        } catch (IOException e) {
            log.info("  error2");
            log.info(" json = "+json);
            return "-1";
        } catch (Exception e) {
            log.info("  error3");
            log.info(" json = "+json);
            return "-1";
        }
        return json;
    }

    /**
     * 外层调用接口，只传入需要用户输入的参数，并补全所有参数
     *
     * @param params
     * @return JSON报文
     */
    public abstract String exec(Map<String, String> params);
}
