package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.fans.common.model.UserProductionRelation;
import com.ptteng.fans.common.service.UserProductionRelationService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class UserProductionRelationServiceImpl extends BaseDaoServiceImpl implements
    UserProductionRelationService {


  private static final Log log = LogFactory.getLog(UserProductionRelationServiceImpl.class);


  @Override
  public Long insert(UserProductionRelation userProductionRelation)
      throws ServiceException, ServiceDaoException {

    log.info(" insert data : " + userProductionRelation);

    if (userProductionRelation == null) {
      return null;
    }

    long currentTimeMillis = System.currentTimeMillis();
    userProductionRelation.setCreateAt(currentTimeMillis);
    userProductionRelation.setUpdateAt(currentTimeMillis);

    Long result = null;
    try {
      result = (Long) dao.save(userProductionRelation);
    } catch (DaoException e) {
      log.error(" insert wrong : " + userProductionRelation);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }

    log.info(" insert data success : " + result);

    return result;
  }


  @Override
  public List<UserProductionRelation> insertList(
      List<UserProductionRelation> userProductionRelationList)
      throws ServiceException, ServiceDaoException {

    log.info(" insert lists : " + (userProductionRelationList == null ? "null"
        : userProductionRelationList.size()));

    List<UserProductionRelation> resultList = null;

    if (CollectionUtils.isEmpty(userProductionRelationList)) {
      return new ArrayList<UserProductionRelation>();
    }

    long currentTimeMillis = System.currentTimeMillis();
    for (UserProductionRelation userProductionRelation : userProductionRelationList) {
      userProductionRelation.setCreateAt(currentTimeMillis);
      userProductionRelation.setUpdateAt(currentTimeMillis);
    }

    try {
      resultList = (List<UserProductionRelation>) dao.batchSave(userProductionRelationList);
    } catch (DaoException e) {
      log.error(" insert list wrong : " + userProductionRelationList);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }

    log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

    return resultList;


  }


  @Override
  public boolean delete(Long id) throws ServiceException, ServiceDaoException {

    log.info(" delete data : " + id);

    boolean result = false;

    if (id == null) {
      return true;
    }

    try {
      result = dao.delete(UserProductionRelation.class, id);
    } catch (DaoException e) {
      log.error(" delete wrong : " + id);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }

    log.info(" delete data success : " + id);

    return result;

  }


  @Override
  public boolean update(UserProductionRelation userProductionRelation)
      throws ServiceException, ServiceDaoException {

    log.info(" update data : " + (userProductionRelation == null ? "null"
        : userProductionRelation.getId()));

    boolean result = false;

    if (userProductionRelation == null) {
      return true;
    }

    userProductionRelation.setUpdateAt(System.currentTimeMillis());

    try {
      result = dao.update(userProductionRelation);
    } catch (DaoException e) {
      log.error(" update wrong : " + userProductionRelation);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }
    if (log.isInfoEnabled()) {
      log.info(" update data success : " + userProductionRelation);
    }
    return result;
  }


  @Override
  public boolean updateList(List<UserProductionRelation> userProductionRelationList)
      throws ServiceException, ServiceDaoException {

    log.info(" update lists : " + (userProductionRelationList == null ? "null"
        : userProductionRelationList.size()));

    boolean result = false;

    if (CollectionUtils.isEmpty(userProductionRelationList)) {
      return true;
    }

    long currentTimeMillis = System.currentTimeMillis();
    for (UserProductionRelation userProductionRelation : userProductionRelationList) {
      userProductionRelation.setUpdateAt(currentTimeMillis);
    }

    try {
      result = dao.batchUpdate(userProductionRelationList);
    } catch (DaoException e) {
      log.error(" update list wrong : " + userProductionRelationList);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }

    log.info(" update lists success : " + userProductionRelationList.size());

    return result;
  }


  @Override
  public UserProductionRelation getObjectById(Long id)
      throws ServiceException, ServiceDaoException {

    log.info(" get data : " + id);

    UserProductionRelation userProductionRelation = null;

    if (id == null) {
      return userProductionRelation;
    }

    try {
      userProductionRelation = (UserProductionRelation) dao.get(UserProductionRelation.class, id);
    } catch (DaoException e) {
      log.error(" get wrong : " + id);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }

    log.info(" get data success : " + id);

    return userProductionRelation;
  }


  @Override
  public List<UserProductionRelation> getObjectsByIds(List<Long> ids)
      throws ServiceException, ServiceDaoException {

    log.info(" get lists : " + (ids == null ? "null" : ids));

    List<UserProductionRelation> userProductionRelation = null;

    if (CollectionUtils.isEmpty(ids)) {
      return new ArrayList<UserProductionRelation>();
    }

    try {
      userProductionRelation = (List<UserProductionRelation>) dao
          .getList(UserProductionRelation.class, ids);
    } catch (DaoException e) {
      log.error(" get wrong : " + ids);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }

    log.info(" get data success : " + (userProductionRelation == null ? "null"
        : userProductionRelation.size()));

    return userProductionRelation;
  }


  @Override
  public List<Long> getUserProductionRelationIds(Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {

    log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
    List<Long> idList = null;

    if (start == null) {
      start = 0;
    }

    if (limit == null) {
      limit = Integer.MAX_VALUE;
    }

    try {
      idList = dao
          .getIdList("getUserProductionRelationIdsAll", new Object[]{}, start, limit, false);
    } catch (DaoException e) {
      log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }
    if (log.isInfoEnabled()) {
      log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
    }
    return idList;
  }


  @Override
  public Integer countUserProductionRelationIds() throws ServiceException,
      ServiceDaoException {
    Integer count = 0;
    try {
      count = dao.count("getUserProductionRelationIdsAll", new Object[]{});
    } catch (DaoException e) {
      log.error(" count by getUserProductionRelationIds ");
      log.error(e);
      e.printStackTrace();
      throw new ServiceDaoException(e);
    }
    if (log.isInfoEnabled()) {
      log.info(" count  : " + count);
    }
    return count;
  }

}

