package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.fans.common.model.UserApplicationRelation;
import com.ptteng.fans.common.service.UserApplicationRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserApplicationRelationServiceImpl extends BaseDaoServiceImpl implements UserApplicationRelationService {

 

	private static final Log log = LogFactory.getLog(UserApplicationRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserApplicationRelation userApplicationRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userApplicationRelation);

		if (userApplicationRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userApplicationRelation.setCreateAt(currentTimeMillis);
		userApplicationRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userApplicationRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userApplicationRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserApplicationRelation> insertList(List<UserApplicationRelation> userApplicationRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userApplicationRelationList == null ? "null" : userApplicationRelationList.size()));
      
		List<UserApplicationRelation> resultList = null;

		if (CollectionUtils.isEmpty(userApplicationRelationList)) {
			return new ArrayList<UserApplicationRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserApplicationRelation userApplicationRelation : userApplicationRelationList) {
			userApplicationRelation.setCreateAt(currentTimeMillis);
			userApplicationRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserApplicationRelation>) dao.batchSave(userApplicationRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userApplicationRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserApplicationRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserApplicationRelation userApplicationRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userApplicationRelation == null ? "null" : userApplicationRelation.getId()));

		boolean result = false;

		if (userApplicationRelation == null) {
			return true;
		}

		userApplicationRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userApplicationRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userApplicationRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userApplicationRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserApplicationRelation> userApplicationRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userApplicationRelationList == null ? "null" : userApplicationRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userApplicationRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserApplicationRelation userApplicationRelation : userApplicationRelationList) {
			userApplicationRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userApplicationRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userApplicationRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userApplicationRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserApplicationRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserApplicationRelation userApplicationRelation = null;

		if (id == null) {
			return userApplicationRelation;
		}

		try {
			userApplicationRelation = (UserApplicationRelation) dao.get(UserApplicationRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userApplicationRelation;		
		}	
		  
    	   
		@Override
		public List<UserApplicationRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserApplicationRelation> userApplicationRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserApplicationRelation>();
		}

		try {
			userApplicationRelation = (List<UserApplicationRelation>) dao.getList(UserApplicationRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userApplicationRelation == null ? "null" : userApplicationRelation.size()));
    
		return userApplicationRelation;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getUserApplicationRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserApplicationRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserApplicationRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserApplicationRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserApplicationRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

