package com.ptteng.fans.common.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.fans.common.model.ProductionRecord;
import com.ptteng.fans.common.service.ProductionRecordService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ProductionRecordServiceImpl extends BaseDaoServiceImpl implements ProductionRecordService {

 

	private static final Log log = LogFactory.getLog(ProductionRecordServiceImpl.class);



		   
		@Override
		public Long insert(ProductionRecord productionRecord)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + productionRecord);

		if (productionRecord == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		productionRecord.setCreateAt(currentTimeMillis);
		productionRecord.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(productionRecord);
		} catch (DaoException e) {
			log.error(" insert wrong : " + productionRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<ProductionRecord> insertList(List<ProductionRecord> productionRecordList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (productionRecordList == null ? "null" : productionRecordList.size()));
      
		List<ProductionRecord> resultList = null;

		if (CollectionUtils.isEmpty(productionRecordList)) {
			return new ArrayList<ProductionRecord>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ProductionRecord productionRecord : productionRecordList) {
			productionRecord.setCreateAt(currentTimeMillis);
			productionRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<ProductionRecord>) dao.batchSave(productionRecordList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + productionRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(ProductionRecord.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(ProductionRecord productionRecord)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (productionRecord == null ? "null" : productionRecord.getId()));

		boolean result = false;

		if (productionRecord == null) {
			return true;
		}

		productionRecord.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(productionRecord);
		} catch (DaoException e) {
			log.error(" update wrong : " + productionRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + productionRecord);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<ProductionRecord> productionRecordList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (productionRecordList == null ? "null" : productionRecordList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(productionRecordList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ProductionRecord productionRecord : productionRecordList) {
			productionRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(productionRecordList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + productionRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + productionRecordList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public ProductionRecord getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		ProductionRecord productionRecord = null;

		if (id == null) {
			return productionRecord;
		}

		try {
			productionRecord = (ProductionRecord) dao.get(ProductionRecord.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return productionRecord;		
		}	
		  
    	   
		@Override
		public List<ProductionRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<ProductionRecord> productionRecord = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<ProductionRecord>();
		}

		try {
			productionRecord = (List<ProductionRecord>) dao.getList(ProductionRecord.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (productionRecord == null ? "null" : productionRecord.size()));
    
		return productionRecord;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProductionRecordIdsByProductionId(Long productionId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by productionId,start,limit  : " + productionId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getProductionRecordIdsByProductionId", new Object[] { productionId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by productionId,start,limit)  : " + productionId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProductionRecordIdsByProductionId(Long productionId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by productionId  : " + productionId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getProductionRecordIdsByProductionId", new Object[] { productionId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by productionId)  : " + productionId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getProductionRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getProductionRecordIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countProductionRecordIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getProductionRecordIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getProductionRecordIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

