package com.ptteng.fans.common.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.fans.common.model.Poster;
import com.ptteng.fans.common.service.PosterService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class PosterServiceImpl extends BaseDaoServiceImpl implements PosterService {

 

	private static final Log log = LogFactory.getLog(PosterServiceImpl.class);



		   
		@Override
		public Long insert(Poster poster)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + poster);

		if (poster == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		poster.setCreateAt(currentTimeMillis);
		poster.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(poster);
		} catch (DaoException e) {
			log.error(" insert wrong : " + poster);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Poster> insertList(List<Poster> posterList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (posterList == null ? "null" : posterList.size()));
      
		List<Poster> resultList = null;

		if (CollectionUtils.isEmpty(posterList)) {
			return new ArrayList<Poster>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Poster poster : posterList) {
			poster.setCreateAt(currentTimeMillis);
			poster.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Poster>) dao.batchSave(posterList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + posterList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Poster.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Poster poster)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (poster == null ? "null" : poster.getId()));

		boolean result = false;

		if (poster == null) {
			return true;
		}

		poster.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(poster);
		} catch (DaoException e) {
			log.error(" update wrong : " + poster);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + poster);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Poster> posterList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (posterList == null ? "null" : posterList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(posterList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Poster poster : posterList) {
			poster.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(posterList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + posterList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + posterList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Poster getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Poster poster = null;

		if (id == null) {
			return poster;
		}

		try {
			poster = (Poster) dao.get(Poster.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return poster;		
		}	
		  
    	   
		@Override
		public List<Poster> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Poster> poster = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Poster>();
		}

		try {
			poster = (List<Poster>) dao.getList(Poster.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (poster == null ? "null" : poster.size()));
    
		return poster;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getPosterIdsByStatusAndClassifyIdOrderByUpdateAt(Integer status,Long classifyId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by status,classifyId,start,limit  : " + status+" , "+classifyId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getPosterIdsByStatusAndClassifyIdOrderByUpdateAt", new Object[] { status,classifyId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by status,classifyId,start,limit)  : " + status+" , "+classifyId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countPosterIdsByStatusAndClassifyIdOrderByUpdateAt(Integer status,Long classifyId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by status,classifyId  : " + status+" , "+classifyId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getPosterIdsByStatusAndClassifyIdOrderByUpdateAt", new Object[] { status,classifyId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by status,classifyId)  : " + status+" , "+classifyId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getPosterIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getPosterIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countPosterIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getPosterIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getPosterIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

